/*
 * Decompiled with CFR 0.152.
 */
package org.skyscreamer.nevado.jms.performance;

import org.skyscreamer.nevado.jms.performance.PerformanceTally;

public class PerformanceResult {
    private final int _numMessagesSent;
    private final int _numMessagesReceived;
    private final int _messageSize;
    private final int _numThreads;
    private final int _numDupMessages;
    private final int _numMissedMessages;
    private final int _numOutOfOrder;
    private final long _totalSendTimeMs;
    private final long _totalReceiveTimeMs;

    public PerformanceResult(int numMessagesSent, PerformanceTally tally, int messageSize, int numThreads, long sendTime, long receiveTime) {
        this._numMessagesSent = numMessagesSent;
        this._numMessagesReceived = tally.getNumMessagesReceived();
        this._messageSize = messageSize;
        this._numThreads = numThreads;
        this._numDupMessages = tally.getNumDupMessages();
        this._numMissedMessages = tally.getNumMissedMessages();
        this._numOutOfOrder = tally.getNumOutOfOrder();
        this._totalSendTimeMs = sendTime;
        this._totalReceiveTimeMs = receiveTime;
    }

    public int getNumMessagesSent() {
        return this._numMessagesSent;
    }

    public int getNumMessagesReceived() {
        return this._numMessagesReceived;
    }

    public int getMessageSize() {
        return this._messageSize;
    }

    public int getNumThreads() {
        return this._numThreads;
    }

    public int getNumDupMessages() {
        return this._numDupMessages;
    }

    public int getNumMissedMessages() {
        return this._numMissedMessages;
    }

    public int getNumOutOfOrder() {
        return this._numOutOfOrder;
    }

    public long getTotalSendTimeMs() {
        return this._totalSendTimeMs;
    }

    public long getTotalReceiveTimeMs() {
        return this._totalReceiveTimeMs;
    }
}

