/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.Multimap;
import java.util.Arrays;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.checks.IdenticalCasesInSwitchCheck;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.java.model.SyntacticEquivalence;
import org.sonar.plugins.java.api.tree.CaseGroupTree;
import org.sonar.plugins.java.api.tree.ConditionalExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IfStatementTree;
import org.sonar.plugins.java.api.tree.SwitchStatementTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S3923")
public class AllBranchesAreIdenticalCheck
extends IdenticalCasesInSwitchCheck {
    private static final String IF_SWITCH_MSG = "Remove this conditional structure or edit its code blocks so that they're not all the same.";

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.SWITCH_STATEMENT, Tree.Kind.IF_STATEMENT, Tree.Kind.CONDITIONAL_EXPRESSION);
    }

    @Override
    public void visitNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.SWITCH_STATEMENT})) {
            SwitchStatementTree switchStatement = (SwitchStatementTree)tree;
            Multimap<CaseGroupTree, CaseGroupTree> identicalBranches = this.checkSwitchStatement(switchStatement);
            if (AllBranchesAreIdenticalCheck.allBranchesSame(identicalBranches, switchStatement.cases().size())) {
                this.reportIssue((Tree)((SwitchStatementTree)tree).switchKeyword(), IF_SWITCH_MSG);
            }
        } else if (tree.is(new Tree.Kind[]{Tree.Kind.IF_STATEMENT})) {
            if (!tree.parent().is(new Tree.Kind[]{Tree.Kind.IF_STATEMENT})) {
                IfStatementTree ifStatementTree = (IfStatementTree)tree;
                IdenticalCasesInSwitchCheck.IfElseChain ifElseChain = AllBranchesAreIdenticalCheck.checkIfStatement(ifStatementTree);
                if (AllBranchesAreIdenticalCheck.allBranchesSame(ifElseChain.branches, ifElseChain.totalBranchCount)) {
                    this.reportIssue((Tree)ifStatementTree.ifKeyword(), IF_SWITCH_MSG);
                }
            }
        } else {
            this.checkConditionalExpression((ConditionalExpressionTree)tree);
        }
    }

    private void checkConditionalExpression(ConditionalExpressionTree node) {
        if (SyntacticEquivalence.areEquivalent((Tree)ExpressionUtils.skipParentheses((ExpressionTree)node.trueExpression()), (Tree)ExpressionUtils.skipParentheses((ExpressionTree)node.falseExpression()))) {
            this.reportIssue((Tree)node.condition(), (Tree)node.questionToken(), "This conditional operation returns the same value whether the condition is \"true\" or \"false\".");
        }
    }
}

