/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.base.MoreObjects;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Objects;
import org.sonar.check.Rule;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.matcher.MethodMatcherCollection;
import org.sonar.java.matcher.NameCriteria;
import org.sonar.java.matcher.TypeCriteria;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.ReturnStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TryStatementTree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S2970")
public class AssertionsCompletenessCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private static final String FEST_ASSERT_SUPERTYPE = "org.fest.assertions.Assert";
    private static final String ASSERTJ_SUPERTYPE = "org.assertj.core.api.AbstractAssert";
    private static final String TRUTH_SUPERTYPE = "com.google.common.truth.TestVerb";
    private static final MethodMatcher MOCKITO_VERIFY = MethodMatcher.create().typeDefinition("org.mockito.Mockito").name("verify").withAnyParameters();
    private static final MethodMatcher ASSERTJ_ASSERT_ALL = MethodMatcher.create().typeDefinition(TypeCriteria.subtypeOf((String)"org.assertj.core.api.SoftAssertions")).name("assertAll").withAnyParameters();
    private static final MethodMatcher ASSERTJ_ASSERT_THAT = MethodMatcher.create().typeDefinition(TypeCriteria.subtypeOf((String)"org.assertj.core.api.AbstractSoftAssertions")).name(NameCriteria.startsWith((String)"assertThat")).withAnyParameters();
    private static final MethodMatcherCollection FEST_LIKE_ASSERT_THAT = MethodMatcherCollection.create((MethodMatcher[])new MethodMatcher[]{AssertionsCompletenessCheck.assertThatOnType("org.fest.assertions.Assertions"), AssertionsCompletenessCheck.assertThatOnType("org.fest.assertions.api.Assertions"), AssertionsCompletenessCheck.assertThatOnType("org.assertj.core.api.AbstractSoftAssertions"), AssertionsCompletenessCheck.assertThatOnType("org.assertj.core.api.Assertions"), AssertionsCompletenessCheck.assertThatOnType("org.assertj.core.api.AbstractStandardSoftAssertions"), AssertionsCompletenessCheck.assertThatOnType("org.assertj.core.api.StrictAssertions"), AssertionsCompletenessCheck.methodWithName("com.google.common.truth.Truth", NameCriteria.startsWith((String)"assert"))});
    private static final MethodMatcherCollection FEST_LIKE_EXCLUSIONS = MethodMatcherCollection.create((MethodMatcher[])new MethodMatcher[]{AssertionsCompletenessCheck.methodWithName("org.fest.assertions.Assert", NameCriteria.startsWith((String)"as")), AssertionsCompletenessCheck.methodWithName("org.fest.assertions.Assert", NameCriteria.startsWith((String)"using")), AssertionsCompletenessCheck.methodWithName("org.fest.assertions.Assert", NameCriteria.startsWith((String)"with")), AssertionsCompletenessCheck.methodWithName("org.fest.assertions.Assert", NameCriteria.is((String)"describedAs")), AssertionsCompletenessCheck.methodWithName("org.fest.assertions.Assert", NameCriteria.is((String)"overridingErrorMessage")), AssertionsCompletenessCheck.methodWithName("org.assertj.core.api.AbstractAssert", NameCriteria.startsWith((String)"as")), AssertionsCompletenessCheck.methodWithName("org.assertj.core.api.AbstractAssert", NameCriteria.startsWith((String)"using")), AssertionsCompletenessCheck.methodWithName("org.assertj.core.api.AbstractAssert", NameCriteria.startsWith((String)"with")), AssertionsCompletenessCheck.methodWithName("org.assertj.core.api.AbstractAssert", NameCriteria.is((String)"describedAs")), AssertionsCompletenessCheck.methodWithName("org.assertj.core.api.AbstractAssert", NameCriteria.is((String)"overridingErrorMessage")), AssertionsCompletenessCheck.methodWithName("com.google.common.truth.TestVerb", NameCriteria.is((String)"that"))});
    private Boolean chainedToAnyMethodButFestExclusions = null;
    private JavaFileScannerContext context;
    private final Deque<Boolean> containsAssertThatWithoutAssertAll = new ArrayDeque<Boolean>();

    private static MethodMatcher assertThatOnType(String type) {
        return MethodMatcher.create().typeDefinition(type).name("assertThat").addParameter(TypeCriteria.anyType());
    }

    private static MethodMatcher methodWithName(String superType, NameCriteria nameCriteria) {
        return MethodMatcher.create().typeDefinition(TypeCriteria.subtypeOf((String)superType)).name(nameCriteria).withAnyParameters();
    }

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitVariable(VariableTree tree) {
    }

    public void visitReturnStatement(ReturnStatementTree tree) {
    }

    public void visitMethod(MethodTree methodTree) {
        if (ModifiersUtils.hasModifier((ModifiersTree)methodTree.modifiers(), (Modifier)Modifier.ABSTRACT)) {
            return;
        }
        this.containsAssertThatWithoutAssertAll.push(false);
        super.visitMethod(methodTree);
        if (Boolean.TRUE.equals(this.containsAssertThatWithoutAssertAll.pop())) {
            this.context.reportIssue((JavaCheck)this, (Tree)methodTree.block().closeBraceToken(), "Add a call to 'assertAll' after all 'assertThat'.");
        }
    }

    public void visitMethodInvocation(MethodInvocationTree mit) {
        this.checkForAssertJSoftAssertions(mit);
        if (this.incompleteAssertion(mit)) {
            return;
        }
        Boolean previous = this.chainedToAnyMethodButFestExclusions;
        this.chainedToAnyMethodButFestExclusions = (Boolean)MoreObjects.firstNonNull((Object)this.chainedToAnyMethodButFestExclusions, (Object)false) != false || !FEST_LIKE_EXCLUSIONS.anyMatch(mit);
        this.scan((Tree)mit.methodSelect());
        this.chainedToAnyMethodButFestExclusions = previous;
    }

    public void visitTryStatement(TryStatementTree tree) {
        boolean hasAutoCloseableSoftAssertion = tree.resources().stream().map(VariableTree::symbol).map(Symbol::type).filter(Objects::nonNull).filter(type -> type.isSubtypeOf("org.assertj.core.api.AutoCloseableSoftAssertions")).findFirst().isPresent();
        super.visitTryStatement(tree);
        if (hasAutoCloseableSoftAssertion) {
            this.checkAssertJAssertAll((Tree)tree.block().closeBraceToken(), "Add one or more 'assertThat' before the end of this try block.");
        }
    }

    private void checkForAssertJSoftAssertions(MethodInvocationTree mit) {
        if (ASSERTJ_ASSERT_ALL.matches(mit)) {
            this.checkAssertJAssertAll((Tree)mit.methodSelect(), "Add one or more 'assertThat' before 'assertAll'.");
        } else if (ASSERTJ_ASSERT_THAT.matches(mit) && !AssertionsCompletenessCheck.isJUnitSoftAssertions(mit)) {
            AssertionsCompletenessCheck.set(this.containsAssertThatWithoutAssertAll, true);
        }
    }

    private void checkAssertJAssertAll(Tree issueLocation, String issueMessage) {
        if (Boolean.TRUE.equals(this.containsAssertThatWithoutAssertAll.peek())) {
            AssertionsCompletenessCheck.set(this.containsAssertThatWithoutAssertAll, false);
        } else {
            this.context.reportIssue((JavaCheck)this, issueLocation, issueMessage);
        }
    }

    private static boolean isJUnitSoftAssertions(MethodInvocationTree mit) {
        ExpressionTree expressionTree = mit.methodSelect();
        if (expressionTree.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            Type type = ((MemberSelectExpressionTree)expressionTree).expression().symbolType();
            return type.isSubtypeOf("org.assertj.core.api.JUnitSoftAssertions") || type.isSubtypeOf("org.assertj.core.api.Java6JUnitSoftAssertions");
        }
        return false;
    }

    private static void set(Deque<Boolean> collection, boolean value) {
        if (Boolean.TRUE.equals(collection.peek()) != value) {
            collection.pop();
            collection.push(value);
        }
    }

    private boolean incompleteAssertion(MethodInvocationTree mit) {
        if ((FEST_LIKE_ASSERT_THAT.anyMatch(mit) && mit.arguments().size() == 1 || MOCKITO_VERIFY.matches(mit)) && !Boolean.TRUE.equals(this.chainedToAnyMethodButFestExclusions)) {
            this.context.reportIssue((JavaCheck)this, (Tree)mit.methodSelect(), "Complete the assertion.");
            return true;
        }
        return false;
    }
}

