/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.RspecKey;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="ClassCyclomaticComplexity")
@RspecKey(value="S1311")
public class ClassComplexityCheck
extends IssuableSubscriptionVisitor {
    private static final int DEFAULT_MAX = 200;
    @RuleProperty(description="Maximum complexity allowed.", defaultValue="200")
    private int max = 200;

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.CLASS);
    }

    public void visitNode(Tree tree) {
        int size = this.context.getComplexityNodes(tree).size();
        if (size > this.max) {
            ClassTree classTree = (ClassTree)tree;
            SyntaxToken report = classTree.simpleName() == null ? classTree.openBraceToken() : classTree.simpleName();
            this.reportIssue((Tree)report, "The Cyclomatic Complexity of this class is " + size + " which is greater than " + this.max + " authorized.", (List)ImmutableList.of(), size - this.max);
        }
    }

    public void setMax(int max) {
        this.max = max;
    }
}

