/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.model.declaration.MethodTreeImpl;
import org.sonar.java.resolve.JavaType;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1698")
public class CompareObjectWithEqualsCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private static final String JAVA_LANG_OBJECT = "java.lang.Object";
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        if (context.getSemanticModel() != null) {
            this.scan((Tree)context.getTree());
        }
    }

    public void visitMethod(MethodTree tree) {
        if (!CompareObjectWithEqualsCheck.isEquals(tree)) {
            super.visitMethod(tree);
        }
    }

    private static boolean isEquals(MethodTree tree) {
        return ((MethodTreeImpl)tree).isEqualsMethod();
    }

    public void visitBinaryExpression(BinaryExpressionTree tree) {
        Type rightOpType;
        Type leftOpType;
        super.visitBinaryExpression(tree);
        if (tree.is(new Tree.Kind[]{Tree.Kind.EQUAL_TO, Tree.Kind.NOT_EQUAL_TO}) && !CompareObjectWithEqualsCheck.isExcluded(leftOpType = tree.leftOperand().symbolType(), rightOpType = tree.rightOperand().symbolType()) && CompareObjectWithEqualsCheck.hasObjectOperand(leftOpType, rightOpType) && CompareObjectWithEqualsCheck.bothImplementsEqualsMethod(leftOpType, rightOpType)) {
            this.context.reportIssue((JavaCheck)this, (Tree)tree.operatorToken(), "Use the \"equals\" method if value comparison was intended.");
        }
    }

    private static boolean hasObjectOperand(Type leftOpType, Type rightOpType) {
        return CompareObjectWithEqualsCheck.isObject(leftOpType) || CompareObjectWithEqualsCheck.isObject(rightOpType);
    }

    private static boolean isExcluded(Type leftOpType, Type rightOpType) {
        return CompareObjectWithEqualsCheck.isNullComparison(leftOpType, rightOpType) || CompareObjectWithEqualsCheck.isNumericalComparison(leftOpType, rightOpType) || CompareObjectWithEqualsCheck.isJavaLangClassComparison(leftOpType, rightOpType) || CompareObjectWithEqualsCheck.isObjectType(leftOpType, rightOpType);
    }

    private static boolean isObjectType(Type leftOpType, Type rightOpType) {
        return leftOpType.is(JAVA_LANG_OBJECT) || rightOpType.is(JAVA_LANG_OBJECT);
    }

    private static boolean isObject(Type operandType) {
        return operandType.erasure().isClass() && !operandType.symbol().isEnum();
    }

    private static boolean isNullComparison(Type leftOpType, Type rightOpType) {
        return CompareObjectWithEqualsCheck.isBot(leftOpType) || CompareObjectWithEqualsCheck.isBot(rightOpType);
    }

    private static boolean isNumericalComparison(Type leftOperandType, Type rightOperandType) {
        return leftOperandType.isNumerical() || rightOperandType.isNumerical();
    }

    private static boolean isJavaLangClassComparison(Type leftOpType, Type rightOpType) {
        return leftOpType.is("java.lang.Class") || rightOpType.is("java.lang.Class");
    }

    private static boolean isBot(Type type) {
        return ((JavaType)type).isTagged(13);
    }

    private static boolean bothImplementsEqualsMethod(Type leftOpType, Type rightOpType) {
        return CompareObjectWithEqualsCheck.implementsEqualsMethod(leftOpType) && CompareObjectWithEqualsCheck.implementsEqualsMethod(rightOpType);
    }

    private static boolean implementsEqualsMethod(Type type) {
        Symbol.TypeSymbol symbol = type.symbol();
        return CompareObjectWithEqualsCheck.hasEqualsMethod(symbol) || CompareObjectWithEqualsCheck.parentClassImplementsEquals(symbol);
    }

    private static boolean parentClassImplementsEquals(Symbol.TypeSymbol symbol) {
        Type superClass = symbol.superClass();
        while (superClass != null && superClass.symbol().isTypeSymbol()) {
            Symbol.TypeSymbol superClassSymbol = superClass.symbol();
            if (!superClass.is(JAVA_LANG_OBJECT) && CompareObjectWithEqualsCheck.hasEqualsMethod(superClassSymbol)) {
                return true;
            }
            superClass = superClassSymbol.superClass();
        }
        return false;
    }

    private static boolean hasEqualsMethod(Symbol.TypeSymbol symbol) {
        return symbol.lookupSymbols("equals").stream().anyMatch(CompareObjectWithEqualsCheck::isEqualsMethod);
    }

    private static boolean isEqualsMethod(Symbol symbol) {
        if (symbol.isMethodSymbol()) {
            List parameterTypes = ((Symbol.MethodSymbol)symbol).parameterTypes();
            return parameterTypes.size() == 1 && ((Type)parameterTypes.get(0)).is(JAVA_LANG_OBJECT);
        }
        return false;
    }
}

