/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.JavaPropertiesHelper;
import org.sonar.java.checks.helpers.MethodsHelper;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.matcher.TypeCriteria;
import org.sonar.java.model.LiteralUtils;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2070")
public class DeprecatedHashAlgorithmCheck
extends AbstractMethodDetection {
    private static final String JAVA_LANG_STRING = "java.lang.String";
    private static final List<String> CRYPTO_APIS = Arrays.asList("java.security.AlgorithmParameters", "java.security.AlgorithmParameterGenerator", "java.security.MessageDigest", "java.security.KeyFactory", "java.security.KeyPairGenerator", "java.security.Signature", "javax.crypto.Mac", "javax.crypto.KeyGenerator");
    private static final Map<String, InsecureAlgorithm> ALGORITHM_BY_METHOD_NAME = ImmutableMap.builder().put((Object)"getMd2Digest", (Object)InsecureAlgorithm.MD2).put((Object)"getMd5Digest", (Object)InsecureAlgorithm.MD5).put((Object)"getShaDigest", (Object)InsecureAlgorithm.SHA1).put((Object)"getSha1Digest", (Object)InsecureAlgorithm.SHA1).put((Object)"md2", (Object)InsecureAlgorithm.MD2).put((Object)"md2Hex", (Object)InsecureAlgorithm.MD2).put((Object)"md5", (Object)InsecureAlgorithm.MD5).put((Object)"md5Hex", (Object)InsecureAlgorithm.MD5).put((Object)"sha1", (Object)InsecureAlgorithm.SHA1).put((Object)"sha1Hex", (Object)InsecureAlgorithm.SHA1).put((Object)"sha", (Object)InsecureAlgorithm.SHA1).put((Object)"shaHex", (Object)InsecureAlgorithm.SHA1).build();

    @Override
    protected List<MethodMatcher> getMethodInvocationMatchers() {
        ImmutableList.Builder builder = ImmutableList.builder().add((Object)MethodMatcher.create().typeDefinition("org.apache.commons.codec.digest.DigestUtils").name("getDigest").addParameter(JAVA_LANG_STRING));
        for (String methodName : ALGORITHM_BY_METHOD_NAME.keySet()) {
            builder.add((Object)MethodMatcher.create().typeDefinition("org.apache.commons.codec.digest.DigestUtils").name(methodName).withAnyParameters());
        }
        for (String cryptoApi : CRYPTO_APIS) {
            builder.add((Object)MethodMatcher.create().typeDefinition(cryptoApi).name("getInstance").addParameter(JAVA_LANG_STRING)).add((Object)MethodMatcher.create().typeDefinition(cryptoApi).name("getInstance").addParameter(JAVA_LANG_STRING).addParameter(TypeCriteria.anyType()));
        }
        for (String methodName : ImmutableList.of((Object)"md5", (Object)"sha1")) {
            builder.add((Object)MethodMatcher.create().typeDefinition("com.google.common.hash.Hashing").name(methodName).withoutParameter());
        }
        return builder.build();
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        String methodName = MethodsHelper.methodName(mit).name();
        InsecureAlgorithm algorithm = ALGORITHM_BY_METHOD_NAME.get(methodName);
        if (algorithm == null) {
            algorithm = DeprecatedHashAlgorithmCheck.algorithm((ExpressionTree)mit.arguments().get(0)).orElse(null);
        }
        if (algorithm != null) {
            this.reportIssue((Tree)MethodsHelper.methodName(mit), "Use a stronger hashing algorithm than " + algorithm.toString() + ".");
        }
    }

    private static Optional<InsecureAlgorithm> algorithm(ExpressionTree invocationArgument) {
        ExpressionTree expectedAlgorithm = invocationArgument;
        ExpressionTree defaultPropertyValue = JavaPropertiesHelper.retrievedPropertyDefaultValue(invocationArgument);
        if (defaultPropertyValue != null) {
            expectedAlgorithm = defaultPropertyValue;
        }
        if (expectedAlgorithm.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL})) {
            String algorithmName = LiteralUtils.trimQuotes((String)((LiteralTree)expectedAlgorithm).value());
            return Arrays.stream(InsecureAlgorithm.values()).filter(alg -> alg.match(algorithmName)).findFirst();
        }
        return Optional.empty();
    }

    static enum InsecureAlgorithm {
        MD2,
        MD4,
        MD5,
        MD6,
        RIPEMD160,
        SHA1{

            public String toString() {
                return "SHA-1";
            }
        }
        ,
        DSA{

            @Override
            boolean match(String algorithm) {
                return "DSA".equals(algorithm);
            }
        };


        boolean match(String algorithm) {
            String normalizedName = algorithm.replaceAll("-", "").toLowerCase(Locale.ENGLISH);
            return normalizedName.contains(this.name().toLowerCase(Locale.ENGLISH));
        }
    }
}

