/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.java.resolve.ParametrizedTypeJavaType;
import org.sonar.java.resolve.TypeVariableJavaType;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S1640")
public class EnumMapCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitVariable(VariableTree tree) {
        if (tree.type().symbolType().isSubtypeOf("java.util.Map")) {
            ExpressionTree initializer = tree.initializer();
            if (initializer != null) {
                this.checkNewMap(initializer, EnumMapCheck.hasEnumKey(tree.type().symbolType()));
            }
        } else {
            super.visitVariable(tree);
        }
    }

    public void visitAssignmentExpression(AssignmentExpressionTree tree) {
        if (tree.variable().symbolType().isSubtypeOf("java.util.Map")) {
            this.checkNewMap(tree.expression(), EnumMapCheck.hasEnumKey(tree.variable().symbolType()));
        } else {
            super.visitAssignmentExpression(tree);
        }
    }

    public void visitNewClass(NewClassTree tree) {
        if (tree.symbolType().isSubtypeOf("java.util.HashMap") && EnumMapCheck.hasEnumKey(tree.identifier().symbolType())) {
            this.addIssue((Tree)tree);
        } else {
            super.visitNewClass(tree);
        }
    }

    private void checkNewMap(ExpressionTree given, boolean useEnumKey) {
        NewClassTree newClassTree;
        ExpressionTree expression = ExpressionUtils.skipParentheses((ExpressionTree)given);
        if (expression.is(new Tree.Kind[]{Tree.Kind.NEW_CLASS}) && (newClassTree = (NewClassTree)expression).symbolType().isSubtypeOf("java.util.HashMap") && (useEnumKey || EnumMapCheck.hasEnumKey(newClassTree.identifier().symbolType()))) {
            this.addIssue((Tree)newClassTree);
        }
    }

    private static boolean hasEnumKey(Type type) {
        ParametrizedTypeJavaType parametrizedTypeJavaType;
        List typeParameters;
        if (type instanceof ParametrizedTypeJavaType && !(typeParameters = (parametrizedTypeJavaType = (ParametrizedTypeJavaType)type).typeParameters()).isEmpty()) {
            return parametrizedTypeJavaType.substitution((TypeVariableJavaType)typeParameters.get(0)).symbol().isEnum();
        }
        return false;
    }

    private void addIssue(Tree typeTree) {
        this.context.reportIssue((JavaCheck)this, typeTree, "Convert this Map to an EnumMap.");
    }
}

