/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.sonar.check.Rule;
import org.sonar.java.JavaVersionAwareVisitor;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.plugins.java.api.JavaVersion;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S3725")
public class FilesExistsJDK8Check
extends AbstractMethodDetection
implements JavaVersionAwareVisitor {
    private static final String JAVA_NIO_FILE_FILES = "java.nio.file.Files";
    private static final String EXISTS = "exists";
    private static final String IS_DIRECTORY = "isDirectory";
    private static final Map<String, String> messageParam = ImmutableMap.builder().put((Object)"exists", (Object)"exists").put((Object)"notExists", (Object)"exists").put((Object)"isRegularFile", (Object)"isFile").put((Object)"isDirectory", (Object)"isDirectory").build();

    public boolean isCompatibleWithJavaVersion(JavaVersion version) {
        return version.asInt() == 8;
    }

    @Override
    protected List<MethodMatcher> getMethodInvocationMatchers() {
        return ImmutableList.of((Object)MethodMatcher.create().typeDefinition(JAVA_NIO_FILE_FILES).name(EXISTS).withAnyParameters(), (Object)MethodMatcher.create().typeDefinition(JAVA_NIO_FILE_FILES).name("notExists").withAnyParameters(), (Object)MethodMatcher.create().typeDefinition(JAVA_NIO_FILE_FILES).name("isRegularFile").withAnyParameters(), (Object)MethodMatcher.create().typeDefinition(JAVA_NIO_FILE_FILES).name(IS_DIRECTORY).withAnyParameters());
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        String methodName = mit.symbol().name();
        this.reportIssue((Tree)mit.methodSelect(), "Replace this with a call to the \"toFile()." + messageParam.get(methodName) + "()\" method");
    }
}

