/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1214")
public class InterfaceAsConstantContainerCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.INTERFACE);
    }

    public void visitNode(Tree tree) {
        ClassTree classTree = (ClassTree)tree;
        if (InterfaceAsConstantContainerCheck.hasConstant(classTree)) {
            this.reportIssue((Tree)classTree.simpleName(), "Move constants to a class or enum.");
        }
    }

    private static boolean hasConstant(ClassTree tree) {
        return tree.members().stream().anyMatch(member -> member.is(new Tree.Kind[]{Tree.Kind.VARIABLE}));
    }
}

