/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.model.declaration.MethodTreeImpl;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2096")
public class MainMethodThrowsExceptionCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.METHOD);
    }

    public void visitNode(Tree tree) {
        MethodTreeImpl methodTree = (MethodTreeImpl)tree;
        if (methodTree.isMainMethod() && !methodTree.throwsClauses().isEmpty()) {
            this.reportIssue((Tree)methodTree.throwsToken(), "Remove this throws clause.");
        }
    }
}

