/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.ast.visitors.LinesOfCodeVisitor;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S138")
public class MethodTooBigCheck
extends IssuableSubscriptionVisitor {
    private static final int DEFAULT_MAX = 75;
    @RuleProperty(description="Maximum authorized lines in a method", defaultValue="75")
    public int max = 75;

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.METHOD, (Object)Tree.Kind.CONSTRUCTOR);
    }

    public void visitNode(Tree tree) {
        int lines;
        MethodTree methodTree = (MethodTree)tree;
        BlockTree block = methodTree.block();
        if (block != null && (lines = new LinesOfCodeVisitor().linesOfCode((Tree)block)) > this.max) {
            this.reportIssue((Tree)methodTree.simpleName(), "This method has " + lines + " lines, which is greater than the " + this.max + " lines authorized. Split it into smaller methods.");
        }
    }
}

