/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Locale;
import org.sonar.check.Rule;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifierKeywordTree;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S2333")
public class RedundantModifierCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.INTERFACE, (Object)Tree.Kind.ANNOTATION_TYPE, (Object)Tree.Kind.CLASS, (Object)Tree.Kind.ENUM);
    }

    public void visitNode(Tree tree) {
        ClassTree classTree = (ClassTree)tree;
        for (Tree member : classTree.members()) {
            ModifiersTree modifiers;
            if (member.is(new Tree.Kind[]{Tree.Kind.METHOD})) {
                MethodTree methodTree = (MethodTree)member;
                modifiers = methodTree.modifiers();
                if (RedundantModifierCheck.isInterfaceOrAnnotation(tree)) {
                    this.checkRedundantModifier(modifiers, Modifier.ABSTRACT);
                    this.checkRedundantModifier(modifiers, Modifier.PUBLIC);
                    continue;
                }
                if (!ModifiersUtils.hasModifier((ModifiersTree)classTree.modifiers(), (Modifier)Modifier.FINAL)) continue;
                this.checkRedundantModifier(modifiers, Modifier.FINAL);
                continue;
            }
            if (member.is(new Tree.Kind[]{Tree.Kind.VARIABLE}) && RedundantModifierCheck.isInterfaceOrAnnotation(tree)) {
                VariableTree variableTree = (VariableTree)member;
                modifiers = variableTree.modifiers();
                this.checkRedundantModifier(modifiers, Modifier.PUBLIC);
                this.checkRedundantModifier(modifiers, Modifier.STATIC);
                this.checkRedundantModifier(modifiers, Modifier.FINAL);
                continue;
            }
            if (!member.is(new Tree.Kind[]{Tree.Kind.CONSTRUCTOR}) || !tree.is(new Tree.Kind[]{Tree.Kind.ENUM})) continue;
            this.checkRedundantModifier(((MethodTree)member).modifiers(), Modifier.PRIVATE);
        }
    }

    private static boolean isInterfaceOrAnnotation(Tree tree) {
        return tree.is(new Tree.Kind[]{Tree.Kind.INTERFACE, Tree.Kind.ANNOTATION_TYPE});
    }

    private void checkRedundantModifier(ModifiersTree modifiersTree, Modifier modifier) {
        ModifierKeywordTree foundModifier = ModifiersUtils.getModifier((ModifiersTree)modifiersTree, (Modifier)modifier);
        if (foundModifier != null) {
            this.reportIssue((Tree)foundModifier, "\"" + modifier.toString().toLowerCase(Locale.US) + "\" is redundant in this context.");
        }
    }
}

