/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.model.LiteralUtils;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S3027")
public class StringMethodsOnSingleCharCheck
extends AbstractMethodDetection {
    private static final String STRING = "java.lang.String";

    @Override
    protected List<MethodMatcher> getMethodInvocationMatchers() {
        return ImmutableList.of((Object)MethodMatcher.create().typeDefinition(STRING).name("indexOf").addParameter(STRING), (Object)MethodMatcher.create().typeDefinition(STRING).name("indexOf").addParameter(STRING).addParameter("int"), (Object)MethodMatcher.create().typeDefinition(STRING).name("lastIndexOf").addParameter(STRING), (Object)MethodMatcher.create().typeDefinition(STRING).name("lastIndexOf").addParameter(STRING).addParameter("int"));
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        String argValue;
        ExpressionTree arg = (ExpressionTree)mit.arguments().get(0);
        if (arg.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL}) && ((argValue = LiteralUtils.trimQuotes((String)((LiteralTree)arg).value())).length() == 1 || StringMethodsOnSingleCharCheck.isEscapedChar(argValue))) {
            this.reportIssue((Tree)arg, "Put single-quotes around '" + argValue + "' to use the faster \"" + mit.symbol().name() + "(char)\" method.");
        }
    }

    private static boolean isEscapedChar(String argValue) {
        return argValue.length() == 2 && argValue.charAt(0) == '\\';
    }
}

