/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1449")
public class StringMethodsWithLocaleCheck
extends AbstractMethodDetection {
    private static final String STRING = "java.lang.String";

    @Override
    protected List<MethodMatcher> getMethodInvocationMatchers() {
        return ImmutableList.of((Object)MethodMatcher.create().typeDefinition(STRING).name("toUpperCase").withoutParameter(), (Object)MethodMatcher.create().typeDefinition(STRING).name("toLowerCase").withoutParameter());
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        ExpressionTree report = mit.methodSelect();
        if (report.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            report = ((MemberSelectExpressionTree)report).identifier();
        }
        this.reportIssue((Tree)report, "Define the locale to be used in this String operation.");
    }
}

