/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.MethodsHelper;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.plugins.java.api.tree.ArrayAccessExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.ParenthesizedTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeCastTree;

@Rule(key="S1858")
public class StringToStringCheck
extends AbstractMethodDetection {
    @Override
    protected List<MethodMatcher> getMethodInvocationMatchers() {
        return ImmutableList.of((Object)MethodMatcher.create().typeDefinition("java.lang.String").name("toString").withoutParameter());
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree tree) {
        ExpressionTree expressionTree = StringToStringCheck.extractBaseExpression(((MemberSelectExpressionTree)tree.methodSelect()).expression());
        if (expressionTree.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            this.reportIssue((Tree)expressionTree, String.format("\"%s\" is already a string, there's no need to call \"toString()\" on it.", ((IdentifierTree)expressionTree).identifierToken().text()));
        } else if (expressionTree.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL})) {
            this.reportIssue((Tree)expressionTree, "there's no need to call \"toString()\" on a string literal.");
        } else if (expressionTree.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
            IdentifierTree methodName = MethodsHelper.methodName((MethodInvocationTree)expressionTree);
            this.reportIssue((Tree)methodName, "\"" + methodName + "\" returns a string, there's no need to call \"toString()\".");
        } else if (expressionTree.is(new Tree.Kind[]{Tree.Kind.ARRAY_ACCESS_EXPRESSION})) {
            ArrayAccessExpressionTree arrayAccess = (ArrayAccessExpressionTree)expressionTree;
            IdentifierTree name = StringToStringCheck.extractName(arrayAccess.expression());
            if (name == null) {
                this.reportIssue((Tree)arrayAccess.expression(), "There's no need to call \"toString()\" on an array of String.");
            } else {
                this.reportIssue((Tree)name, String.format("\"%s\" is an array of strings, there's no need to call \"toString()\".", name.identifierToken().text()));
            }
        }
    }

    private static ExpressionTree extractBaseExpression(ExpressionTree tree) {
        ExpressionTree expressionTree = tree;
        while (true) {
            if (expressionTree.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
                expressionTree = ((MemberSelectExpressionTree)expressionTree).identifier();
                continue;
            }
            if (expressionTree.is(new Tree.Kind[]{Tree.Kind.PARENTHESIZED_EXPRESSION})) {
                expressionTree = ((ParenthesizedTree)expressionTree).expression();
                continue;
            }
            if (!expressionTree.is(new Tree.Kind[]{Tree.Kind.TYPE_CAST})) break;
            expressionTree = ((TypeCastTree)expressionTree).expression();
        }
        return expressionTree;
    }

    private static IdentifierTree extractName(ExpressionTree tree) {
        ExpressionTree expressionTree = StringToStringCheck.extractBaseExpression(tree);
        if (expressionTree.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            return (IdentifierTree)expressionTree;
        }
        return null;
    }
}

