/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.Lists;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.CaseLabelTree;
import org.sonar.plugins.java.api.tree.IfStatementTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.SwitchStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TryStatementTree;

@Rule(key="S128")
public class SwitchCaseWithoutBreakCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitSwitchStatement(SwitchStatementTree switchStatement) {
        switchStatement.cases().stream().limit(Math.max(0, switchStatement.cases().size() - 1)).forEach(caseGroup -> {
            CaseLabelTree caseLabel = (CaseLabelTree)caseGroup.labels().get(caseGroup.labels().size() - 1);
            if (Lists.reverse((List)caseGroup.body()).stream().noneMatch(SwitchCaseWithoutBreakCheck::isUnconditionalExit)) {
                this.context.reportIssue((JavaCheck)this, (Tree)caseLabel, "End this switch case with an unconditional break, return or throw statement.");
            }
        });
        super.visitSwitchStatement(switchStatement);
    }

    private static boolean isUnconditionalExit(Tree syntaxNode) {
        switch (syntaxNode.kind()) {
            case BREAK_STATEMENT: 
            case THROW_STATEMENT: 
            case RETURN_STATEMENT: 
            case CONTINUE_STATEMENT: {
                return true;
            }
            case BLOCK: {
                return ((BlockTree)syntaxNode).body().stream().anyMatch(SwitchCaseWithoutBreakCheck::isUnconditionalExit);
            }
            case TRY_STATEMENT: {
                return SwitchCaseWithoutBreakCheck.isUnconditionalExitInTryCatchStatement((TryStatementTree)syntaxNode);
            }
            case IF_STATEMENT: {
                return SwitchCaseWithoutBreakCheck.isUnconditionalExitInIfStatement((IfStatementTree)syntaxNode);
            }
        }
        return false;
    }

    private static boolean isUnconditionalExitInTryCatchStatement(TryStatementTree tryStatement) {
        return SwitchCaseWithoutBreakCheck.isUnconditionalExit((Tree)tryStatement.block()) && tryStatement.catches().stream().allMatch(catchTree -> SwitchCaseWithoutBreakCheck.isUnconditionalExit((Tree)catchTree.block()));
    }

    private static boolean isUnconditionalExitInIfStatement(IfStatementTree ifStatement) {
        if (!SwitchCaseWithoutBreakCheck.isUnconditionalExit((Tree)ifStatement.thenStatement())) {
            return false;
        }
        StatementTree elseStatement = ifStatement.elseStatement();
        if (elseStatement == null) {
            return false;
        }
        return SwitchCaseWithoutBreakCheck.isUnconditionalExit((Tree)elseStatement);
    }
}

