/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.CheckForNull;
import org.sonar.check.Rule;
import org.sonar.java.resolve.JavaSymbol;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.SynchronizedStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;

@Rule(key="S2445")
public class SynchronizedFieldAssignmentCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.SYNCHRONIZED_STATEMENT);
    }

    public void visitNode(Tree tree) {
        if (this.hasSemantic()) {
            SynchronizedStatementTree sst = (SynchronizedStatementTree)tree;
            Symbol field = SynchronizedFieldAssignmentCheck.getField(sst.expression());
            if (field != null) {
                sst.block().accept((TreeVisitor)new AssignmentVisitor(field, (Tree)sst.expression()));
            } else {
                Symbol parameter = SynchronizedFieldAssignmentCheck.getParam(sst.expression());
                if (parameter != null) {
                    this.reportIssue(tree, String.format("\"%s\" is a method parameter, and should not be used for synchronization.", parameter.name()));
                }
            }
        }
    }

    @CheckForNull
    private static Symbol getParam(ExpressionTree tree) {
        Symbol reference;
        if (tree.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) && (reference = ((IdentifierTree)tree).symbol()).owner().isMethodSymbol() && ((JavaSymbol.MethodJavaSymbol)reference.owner()).getParameters().scopeSymbols().contains(reference)) {
            return reference;
        }
        return null;
    }

    @CheckForNull
    private static Symbol getField(ExpressionTree tree) {
        MemberSelectExpressionTree mse;
        if (tree.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            Symbol reference = ((IdentifierTree)tree).symbol();
            if (!reference.isUnknown() && reference.owner().isTypeSymbol()) {
                return reference;
            }
        } else if (tree.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT}) && SynchronizedFieldAssignmentCheck.isField((ExpressionTree)(mse = (MemberSelectExpressionTree)tree))) {
            return SynchronizedFieldAssignmentCheck.getField((ExpressionTree)mse.identifier());
        }
        return null;
    }

    private static boolean isField(ExpressionTree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            Symbol reference = ((IdentifierTree)tree).symbol();
            return !reference.isUnknown() && reference.owner().isTypeSymbol();
        }
        if (tree.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            MemberSelectExpressionTree mse = (MemberSelectExpressionTree)tree;
            ExpressionTree mseExpression = mse.expression();
            if (SynchronizedFieldAssignmentCheck.isThis(mseExpression)) {
                return SynchronizedFieldAssignmentCheck.isField((ExpressionTree)mse.identifier());
            }
            return SynchronizedFieldAssignmentCheck.isField(mseExpression);
        }
        return false;
    }

    private static boolean isThis(ExpressionTree expression) {
        return expression.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) && "this".equals(((IdentifierTree)expression).name());
    }

    private class AssignmentVisitor
    extends BaseTreeVisitor {
        private final Symbol field;
        private final Tree synchronizedStatement;

        public AssignmentVisitor(Symbol field, Tree tree) {
            this.field = field;
            this.synchronizedStatement = tree;
        }

        public void visitAssignmentExpression(AssignmentExpressionTree tree) {
            this.checkSymbolAssignment((Tree)tree.variable());
        }

        private void checkSymbolAssignment(Tree variable) {
            if (variable.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
                if (this.field.equals(((IdentifierTree)variable).symbol())) {
                    SynchronizedFieldAssignmentCheck.this.reportIssue(this.synchronizedStatement, String.format("\"%s\" is not \"private final\", and should not be used for synchronization. ", this.field.name()));
                }
            } else if (variable.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
                this.checkSymbolAssignment((Tree)((MemberSelectExpressionTree)variable).identifier());
            }
        }
    }
}

