/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.ReturnStatementTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2225")
public class ToStringReturningNullCheck
extends IssuableSubscriptionVisitor {
    private boolean insideToString = false;

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.METHOD, (Object)Tree.Kind.RETURN_STATEMENT);
    }

    public void visitNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.METHOD})) {
            this.insideToString = ToStringReturningNullCheck.isToStringDeclaration((MethodTree)tree);
        } else if (this.insideToString) {
            ExpressionTree returnExpression = ExpressionUtils.skipParentheses((ExpressionTree)((ReturnStatementTree)tree).expression());
            if (returnExpression.is(new Tree.Kind[]{Tree.Kind.NULL_LITERAL})) {
                this.reportIssue((Tree)returnExpression, "Return empty string instead.");
            }
        }
    }

    public void leaveNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.METHOD})) {
            this.insideToString = false;
        }
    }

    private static boolean isToStringDeclaration(MethodTree method) {
        return "toString".equals(method.simpleName().name()) && method.parameters().isEmpty();
    }
}

