/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.naming;

import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.RspecKey;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ForEachStatement;
import org.sonar.plugins.java.api.tree.ForStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S00117")
@RspecKey(value="S117")
public class BadLocalVariableNameCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private static final String DEFAULT_FORMAT = "^[a-z][a-zA-Z0-9]*$";
    @RuleProperty(key="format", description="Regular expression used to check the names against.", defaultValue="^[a-z][a-zA-Z0-9]*$")
    public String format = "^[a-z][a-zA-Z0-9]*$";
    private Pattern pattern = null;
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        if (this.pattern == null) {
            this.pattern = Pattern.compile(this.format, 32);
        }
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitClass(ClassTree tree) {
        for (Tree member : tree.members()) {
            if (member.is(new Tree.Kind[]{Tree.Kind.VARIABLE})) {
                this.scan((Tree)((VariableTree)member).initializer());
                continue;
            }
            this.scan(member);
        }
    }

    public void visitForStatement(ForStatementTree tree) {
        this.scan((Tree)tree.statement());
    }

    public void visitForEachStatement(ForEachStatement tree) {
        this.scan((Tree)tree.statement());
    }

    public void visitVariable(VariableTree tree) {
        if (!this.pattern.matcher(tree.simpleName().name()).matches()) {
            this.context.reportIssue((JavaCheck)this, (Tree)tree.simpleName(), "Rename this local variable to match the regular expression '" + this.format + "'.");
        }
        super.visitVariable(tree);
    }
}

