/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.naming;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang.BooleanUtils;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.RspecKey;
import org.sonar.java.model.declaration.MethodTreeImpl;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S00100")
@RspecKey(value="S100")
public class BadMethodNameCheck
extends IssuableSubscriptionVisitor {
    private static final String DEFAULT_FORMAT = "^[a-z][a-zA-Z0-9]*$";
    @RuleProperty(key="format", description="Regular expression used to check the method names against.", defaultValue="^[a-z][a-zA-Z0-9]*$")
    public String format = "^[a-z][a-zA-Z0-9]*$";
    private Pattern pattern = null;

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.METHOD);
    }

    public void scanFile(JavaFileScannerContext context) {
        if (this.pattern == null) {
            this.pattern = Pattern.compile(this.format, 32);
        }
        super.scanFile(context);
    }

    public void visitNode(Tree tree) {
        MethodTree methodTree = (MethodTree)tree;
        if (BadMethodNameCheck.isNotOverriden(methodTree) && !this.pattern.matcher(methodTree.simpleName().name()).matches()) {
            this.reportIssue((Tree)methodTree.simpleName(), "Rename this method name to match the regular expression '" + this.format + "'.");
        }
    }

    private static boolean isNotOverriden(MethodTree methodTree) {
        return BooleanUtils.isFalse((Boolean)((MethodTreeImpl)methodTree).isOverriding());
    }
}

