/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.naming;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1201")
public class MethodNamedEqualsCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.METHOD);
    }

    public void visitNode(Tree tree) {
        if (!this.hasSemantic()) {
            return;
        }
        MethodTree methodTree = (MethodTree)tree;
        if (MethodNamedEqualsCheck.equalsWithSingleParam(methodTree) && !MethodNamedEqualsCheck.hasProperEquals(methodTree)) {
            this.reportIssue((Tree)methodTree.simpleName(), "Either override Object.equals(Object), or rename the method to prevent any confusion.");
        }
    }

    private static boolean equalsWithSingleParam(MethodTree methodTree) {
        return "equals".equalsIgnoreCase(methodTree.simpleName().name()) && methodTree.parameters().size() == 1;
    }

    private static boolean hasProperEquals(MethodTree methodTree) {
        Symbol.MethodSymbol symbol = methodTree.symbol();
        Symbol.TypeSymbol enclosingClass = symbol.enclosingClass();
        return enclosingClass != null && enclosingClass.memberSymbols().stream().anyMatch(MethodNamedEqualsCheck::isEqualsMethod);
    }

    private static boolean isEqualsMethod(Symbol symbol) {
        if (!symbol.isMethodSymbol()) {
            return false;
        }
        if (!"equals".equals(symbol.name())) {
            return false;
        }
        List parameters = ((Symbol.MethodSymbol)symbol).parameterTypes();
        return parameters.size() == 1 && ((Type)parameters.get(0)).is("java.lang.Object");
    }
}

