/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.serialization;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2060")
public class ExternalizableClassConstructorCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.CLASS);
    }

    public void visitNode(Tree tree) {
        if (!this.hasSemantic()) {
            return;
        }
        ClassTree classTree = (ClassTree)tree;
        if (!ExternalizableClassConstructorCheck.isAnonymous(classTree) && ExternalizableClassConstructorCheck.implementsExternalizable(classTree)) {
            Collection constructors = classTree.symbol().lookupSymbols("<init>");
            boolean hasNoArgConstructor = constructors.isEmpty();
            for (Symbol constructor : constructors) {
                if (!ExternalizableClassConstructorCheck.isNoArgConstructor(constructor)) continue;
                hasNoArgConstructor = true;
                break;
            }
            if (!hasNoArgConstructor) {
                this.reportIssue((Tree)classTree.simpleName(), "Add a no-arg constructor to this class.");
            }
        }
    }

    private static boolean isAnonymous(ClassTree classTree) {
        return classTree.simpleName() == null;
    }

    private static boolean implementsExternalizable(ClassTree classTree) {
        return classTree.symbol().type().isSubtypeOf("java.io.Externalizable");
    }

    private static boolean isNoArgConstructor(Symbol constructor) {
        return ((Symbol.MethodSymbol)constructor).parameterTypes().isEmpty();
    }
}

