/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.spring;

import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S3751")
public class RequestMappingMethodPublicCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.METHOD);
    }

    public void visitNode(Tree tree) {
        if (!this.hasSemantic()) {
            return;
        }
        MethodTree methodTree = (MethodTree)tree;
        Symbol.MethodSymbol methodSymbol = methodTree.symbol();
        if (RequestMappingMethodPublicCheck.isClassController(methodSymbol) && RequestMappingMethodPublicCheck.isRequestMappingAnnotated(methodSymbol) && !methodSymbol.isPublic()) {
            this.reportIssue((Tree)methodTree.simpleName(), "Make this method \"public\".");
        }
    }

    private static boolean isClassController(Symbol.MethodSymbol methodSymbol) {
        return methodSymbol.owner().metadata().isAnnotatedWith("org.springframework.stereotype.Controller");
    }

    private static boolean isRequestMappingAnnotated(Symbol.MethodSymbol methodSymbol) {
        return methodSymbol.metadata().isAnnotatedWith("org.springframework.web.bind.annotation.RequestMapping");
    }
}

