/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.unused;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckForNull;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.MethodsHelper;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.matcher.TypeCriteria;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionStatementTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2677")
public class UnusedReturnedDataCheck
extends IssuableSubscriptionVisitor {
    private static final List<MethodMatcher> CHECKED_METHODS = ImmutableList.of((Object)MethodMatcher.create().typeDefinition(TypeCriteria.subtypeOf((String)"java.io.BufferedReader")).name("readLine").withoutParameter(), (Object)MethodMatcher.create().typeDefinition(TypeCriteria.subtypeOf((String)"java.io.Reader")).name("read").withoutParameter());

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.EXPRESSION_STATEMENT, (Object)Tree.Kind.EQUAL_TO, (Object)Tree.Kind.NOT_EQUAL_TO);
    }

    public void visitNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.EXPRESSION_STATEMENT})) {
            CHECKED_METHODS.stream().map(matcher -> UnusedReturnedDataCheck.isTreeMethodInvocation(((ExpressionStatementTree)tree).expression(), matcher)).filter(Objects::nonNull).forEach(mit -> this.raiseIssue(MethodsHelper.methodName(mit)));
        } else {
            BinaryExpressionTree expressionTree = (BinaryExpressionTree)tree;
            ExpressionTree leftOperand = expressionTree.leftOperand();
            ExpressionTree rightOperand = expressionTree.rightOperand();
            for (MethodMatcher matcher2 : CHECKED_METHODS) {
                MethodInvocationTree rightMit;
                MethodInvocationTree leftMit = UnusedReturnedDataCheck.isTreeMethodInvocation(leftOperand, matcher2);
                if (leftMit != null && UnusedReturnedDataCheck.isTreeLiteralNull(rightOperand)) {
                    this.raiseIssue(MethodsHelper.methodName(leftMit));
                }
                if ((rightMit = UnusedReturnedDataCheck.isTreeMethodInvocation(rightOperand, matcher2)) == null || !UnusedReturnedDataCheck.isTreeLiteralNull(leftOperand)) continue;
                this.raiseIssue(MethodsHelper.methodName(rightMit));
            }
        }
    }

    @CheckForNull
    private static MethodInvocationTree isTreeMethodInvocation(ExpressionTree tree, MethodMatcher matcher) {
        MethodInvocationTree methodInvocation;
        ExpressionTree expression = ExpressionUtils.skipParentheses((ExpressionTree)tree);
        if (expression.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION}) && matcher.matches(methodInvocation = (MethodInvocationTree)expression)) {
            return methodInvocation;
        }
        return null;
    }

    private static boolean isTreeLiteralNull(ExpressionTree tree) {
        return ExpressionUtils.skipParentheses((ExpressionTree)tree).is(new Tree.Kind[]{Tree.Kind.NULL_LITERAL});
    }

    private void raiseIssue(IdentifierTree identifierTree) {
        this.reportIssue((Tree)identifierTree, String.format("Use or store the value returned from \"%s\" instead of throwing it away.", identifierTree.identifierToken().text()));
    }
}

