/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.xml.maven;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.sonar.check.Rule;
import org.sonar.java.checks.xml.maven.helpers.MavenDependencyCollector;
import org.sonar.java.xml.maven.PomCheck;
import org.sonar.java.xml.maven.PomCheckContext;
import org.sonar.maven.model.LocatedAttribute;
import org.sonar.maven.model.LocatedTree;
import org.sonar.maven.model.maven2.Dependency;

@Rule(key="S3422")
public class DependencyWithSystemScopeCheck
implements PomCheck {
    public void scanFile(PomCheckContext context) {
        List<Dependency> dependencies = new MavenDependencyCollector(context.getMavenProject()).allDependencies();
        for (Dependency dependency : dependencies) {
            LocatedAttribute scope = dependency.getScope();
            if (scope == null || !"system".equalsIgnoreCase(scope.getValue())) continue;
            String message = "Update this scope.";
            LocatedAttribute systemPath = dependency.getSystemPath();
            List<PomCheckContext.Location> secondaries = DependencyWithSystemScopeCheck.getSecondary(systemPath);
            if (systemPath != null) {
                message = "Update this scope and remove the \"systemPath\".";
            }
            context.reportIssue((PomCheck)this, scope.startLocation().line(), message, secondaries);
        }
    }

    private static List<PomCheckContext.Location> getSecondary(@Nullable LocatedAttribute systemPath) {
        if (systemPath != null && StringUtils.isNotBlank((String)systemPath.getValue())) {
            return Lists.newArrayList((Object[])new PomCheckContext.Location[]{new PomCheckContext.Location("Remove this", (LocatedTree)systemPath)});
        }
        return ImmutableList.of();
    }
}

