/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.jacoco;

import java.io.File;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.batch.sensor.coverage.CoverageType;
import org.sonar.api.component.ResourcePerspectives;
import org.sonar.api.scan.filesystem.PathResolver;
import org.sonar.java.JavaClasspath;
import org.sonar.plugins.jacoco.AbstractAnalyzer;
import org.sonar.plugins.jacoco.JaCoCoExtensions;
import org.sonar.plugins.jacoco.JaCoCoReportMerger;
import org.sonar.plugins.jacoco.JacocoConfiguration;
import org.sonar.plugins.java.api.JavaResourceLocator;

public class JaCoCoOverallSensor
implements Sensor {
    public static final String JACOCO_OVERALL = "jacoco-overall.exec";
    private final JacocoConfiguration configuration;
    private final ResourcePerspectives perspectives;
    private final FileSystem fileSystem;
    private final PathResolver pathResolver;
    private final JavaResourceLocator javaResourceLocator;
    private final JavaClasspath javaClasspath;

    public JaCoCoOverallSensor(JacocoConfiguration configuration, ResourcePerspectives perspectives, FileSystem fileSystem, PathResolver pathResolver, JavaResourceLocator javaResourceLocator, JavaClasspath javaClasspath) {
        this.configuration = configuration;
        this.perspectives = perspectives;
        this.fileSystem = fileSystem;
        this.pathResolver = pathResolver;
        this.javaResourceLocator = javaResourceLocator;
        this.javaClasspath = javaClasspath;
    }

    public void describe(SensorDescriptor descriptor) {
        descriptor.onlyOnLanguage("java").name("JaCoCoOverallSensor");
    }

    public void execute(SensorContext context) {
        File reportUTs = this.pathResolver.relativeFile(this.fileSystem.baseDir(), this.configuration.getReportPath());
        File reportITs = this.pathResolver.relativeFile(this.fileSystem.baseDir(), this.configuration.getItReportPath());
        if (this.shouldExecuteOnProject()) {
            File reportOverall = new File(this.fileSystem.workDir(), JACOCO_OVERALL);
            reportOverall.getParentFile().mkdirs();
            JaCoCoReportMerger.mergeReports(reportOverall, reportUTs, reportITs);
            new OverallAnalyzer(reportOverall).analyse(context);
        }
    }

    public boolean shouldExecuteOnProject() {
        File reportUTs = this.pathResolver.relativeFile(this.fileSystem.baseDir(), this.configuration.getReportPath());
        File reportITs = this.pathResolver.relativeFile(this.fileSystem.baseDir(), this.configuration.getItReportPath());
        boolean foundOneReport = reportUTs.exists() || reportITs.exists();
        boolean shouldExecute = this.configuration.shouldExecuteOnProject(foundOneReport);
        if (!foundOneReport && shouldExecute) {
            JaCoCoExtensions.LOG.info("JaCoCoOverallSensor: JaCoCo reports not found.");
        }
        return shouldExecute;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    class OverallAnalyzer
    extends AbstractAnalyzer {
        private final File report;

        OverallAnalyzer(File report) {
            super(JaCoCoOverallSensor.this.perspectives, JaCoCoOverallSensor.this.javaResourceLocator, JaCoCoOverallSensor.this.javaClasspath, false);
            this.report = report;
        }

        @Override
        protected CoverageType coverageType() {
            return CoverageType.OVERALL;
        }

        @Override
        protected File getReport() {
            return this.report;
        }
    }
}

