/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.debt.internal;

import java.util.List;
import javax.annotation.CheckForNull;
import org.sonar.api.batch.debt.DebtCharacteristic;
import org.sonar.api.batch.debt.DebtModel;
import org.sonar.api.batch.debt.internal.DefaultDebtCharacteristic;
import org.sonar.api.internal.google.common.base.Predicate;
import org.sonar.api.internal.google.common.collect.ArrayListMultimap;
import org.sonar.api.internal.google.common.collect.Iterables;
import org.sonar.api.internal.google.common.collect.Lists;
import org.sonar.api.internal.google.common.collect.Multimap;

public class DefaultDebtModel
implements DebtModel {
    private Multimap<String, DebtCharacteristic> characteristicsByKey = ArrayListMultimap.create();

    public DefaultDebtModel addCharacteristic(DebtCharacteristic characteristic) {
        this.characteristicsByKey.put(null, characteristic);
        return this;
    }

    public DefaultDebtModel addSubCharacteristic(DebtCharacteristic subCharacteristic, String characteristicKey) {
        this.characteristicsByKey.put(characteristicKey, subCharacteristic);
        return this;
    }

    @Override
    public List<DebtCharacteristic> characteristics() {
        return Lists.newArrayList(this.characteristicsByKey.get(null));
    }

    @Override
    public List<DebtCharacteristic> subCharacteristics(String characteristicKey) {
        return Lists.newArrayList(this.characteristicsByKey.get(characteristicKey));
    }

    @Override
    public List<DebtCharacteristic> allCharacteristics() {
        return Lists.newArrayList(this.characteristicsByKey.values());
    }

    @Override
    @CheckForNull
    public DebtCharacteristic characteristicByKey(String key) {
        return Iterables.find(this.characteristicsByKey.values(), new MatchDebtCharacteristicKey(key), null);
    }

    @CheckForNull
    public DebtCharacteristic characteristicById(int id) {
        return Iterables.find(this.characteristicsByKey.values(), new MatchDebtCharacteristicId(id), null);
    }

    private static class MatchDebtCharacteristicId
    implements Predicate<DebtCharacteristic> {
        private final int id;

        public MatchDebtCharacteristicId(int id) {
            this.id = id;
        }

        @Override
        public boolean apply(DebtCharacteristic input) {
            return this.id == ((DefaultDebtCharacteristic)input).id();
        }
    }

    private static class MatchDebtCharacteristicKey
    implements Predicate<DebtCharacteristic> {
        private final String key;

        public MatchDebtCharacteristicKey(String key) {
            this.key = key;
        }

        @Override
        public boolean apply(DebtCharacteristic input) {
            return this.key.equals(input.key());
        }
    }
}

