/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.fs.internal;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.batch.BatchSide;
import org.sonar.api.batch.fs.internal.DefaultInputFile;
import org.sonar.api.internal.apachecommons.codec.binary.Hex;
import org.sonar.api.internal.apachecommons.codec.digest.DigestUtils;
import org.sonar.api.internal.apachecommons.io.ByteOrderMark;
import org.sonar.api.internal.apachecommons.io.input.BOMInputStream;
import org.sonar.api.internal.google.common.primitives.Ints;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;

@BatchSide
public class FileMetadata {
    private static final Logger LOG = Loggers.get(FileMetadata.class);
    private static final char LINE_FEED = '\n';
    private static final char CARRIAGE_RETURN = '\r';

    public Metadata readMetadata(File file, Charset encoding) {
        LineCounter lineCounter = new LineCounter(file, encoding);
        FileHashComputer fileHashComputer = new FileHashComputer(file);
        LineOffsetCounter lineOffsetCounter = new LineOffsetCounter();
        FileMetadata.readFile(file, encoding, lineCounter, fileHashComputer, lineOffsetCounter);
        return new Metadata(lineCounter.lines(), lineCounter.nonBlankLines(), fileHashComputer.getHash(), lineOffsetCounter.getOriginalLineOffsets(), lineOffsetCounter.getLastValidOffset());
    }

    public Metadata readMetadata(Reader reader) {
        LineCounter lineCounter = new LineCounter(new File("fromString"), StandardCharsets.UTF_16);
        FileHashComputer fileHashComputer = new FileHashComputer(new File("fromString"));
        LineOffsetCounter lineOffsetCounter = new LineOffsetCounter();
        try {
            FileMetadata.read(reader, lineCounter, fileHashComputer, lineOffsetCounter);
        }
        catch (IOException e) {
            throw new IllegalStateException("Should never occurs", e);
        }
        return new Metadata(lineCounter.lines(), lineCounter.nonBlankLines(), fileHashComputer.getHash(), lineOffsetCounter.getOriginalLineOffsets(), lineOffsetCounter.getLastValidOffset());
    }

    public static void readFile(File file, Charset encoding, CharHandler ... handlers) {
        try (BOMInputStream bomIn = new BOMInputStream((InputStream)new FileInputStream(file), ByteOrderMark.UTF_8, ByteOrderMark.UTF_16LE, ByteOrderMark.UTF_16BE, ByteOrderMark.UTF_32LE, ByteOrderMark.UTF_32BE);
             BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)bomIn, encoding));){
            FileMetadata.read(reader, handlers);
        }
        catch (IOException e) {
            throw new IllegalStateException(String.format("Fail to read file '%s' with encoding '%s'", file.getAbsolutePath(), encoding), e);
        }
    }

    private static void read(Reader reader, CharHandler ... handlers) throws IOException {
        char c = '\u0000';
        int i = reader.read();
        boolean afterCR = false;
        while (i != -1) {
            c = (char)i;
            if (afterCR) {
                for (CharHandler handler : handlers) {
                    if (c == '\r') {
                        handler.newLine();
                        handler.handleAll(c);
                        continue;
                    }
                    if (c == '\n') {
                        handler.handleAll(c);
                        handler.newLine();
                        afterCR = false;
                        continue;
                    }
                    handler.newLine();
                    handler.handleIgnoreEoL(c);
                    handler.handleAll(c);
                    afterCR = false;
                }
                afterCR = c == '\r';
            } else if (c == '\n') {
                for (CharHandler handler : handlers) {
                    handler.handleAll(c);
                    handler.newLine();
                }
            } else if (c == '\r') {
                afterCR = true;
                for (CharHandler handler : handlers) {
                    handler.handleAll(c);
                }
            } else {
                for (CharHandler handler : handlers) {
                    handler.handleIgnoreEoL(c);
                    handler.handleAll(c);
                }
            }
            i = reader.read();
        }
        for (CharHandler handler : handlers) {
            if (afterCR) {
                handler.newLine();
            }
            handler.eof();
        }
    }

    public static void computeLineHashesForIssueTracking(DefaultInputFile f, LineHashConsumer consumer) {
        FileMetadata.readFile(f.file(), f.charset(), new LineHashComputer(consumer, f.file()));
    }

    public static interface LineHashConsumer {
        public void consume(int var1, @Nullable byte[] var2);
    }

    public static class Metadata {
        final int lines;
        final int nonBlankLines;
        final String hash;
        final int[] originalLineOffsets;
        final int lastValidOffset;

        private Metadata(int lines, int nonBlankLines, String hash, List<Integer> originalLineOffsets, int lastValidOffset) {
            this.lines = lines;
            this.nonBlankLines = nonBlankLines;
            this.hash = hash;
            this.originalLineOffsets = Ints.toArray(originalLineOffsets);
            this.lastValidOffset = lastValidOffset;
        }
    }

    private static class LineOffsetCounter
    extends CharHandler {
        private int currentOriginalOffset = 0;
        private List<Integer> originalLineOffsets = new ArrayList<Integer>();
        private int lastValidOffset = 0;

        public LineOffsetCounter() {
            this.originalLineOffsets.add(0);
        }

        @Override
        protected void handleAll(char c) {
            ++this.currentOriginalOffset;
        }

        @Override
        protected void newLine() {
            this.originalLineOffsets.add(this.currentOriginalOffset);
        }

        @Override
        protected void eof() {
            this.lastValidOffset = this.currentOriginalOffset;
        }

        public List<Integer> getOriginalLineOffsets() {
            return this.originalLineOffsets;
        }

        public int getLastValidOffset() {
            return this.lastValidOffset;
        }
    }

    private static class LineHashComputer
    extends CharHandler {
        private final MessageDigest lineMd5Digest = DigestUtils.getMd5Digest();
        private final CharsetEncoder encoder;
        private final StringBuilder sb = new StringBuilder();
        private final LineHashConsumer consumer;
        private final File file;
        private int line = 1;

        public LineHashComputer(LineHashConsumer consumer, File f) {
            this.consumer = consumer;
            this.file = f;
            this.encoder = StandardCharsets.UTF_8.newEncoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        }

        @Override
        protected void handleIgnoreEoL(char c) {
            if (!Character.isWhitespace(c)) {
                this.sb.append(c);
            }
        }

        @Override
        protected void newLine() {
            this.processBuffer();
            this.sb.setLength(0);
            ++this.line;
        }

        @Override
        protected void eof() {
            if (this.line > 0) {
                this.processBuffer();
            }
        }

        private void processBuffer() {
            try {
                if (this.sb.length() > 0) {
                    ByteBuffer encoded = this.encoder.encode(CharBuffer.wrap(this.sb));
                    this.lineMd5Digest.update(encoded.array(), 0, encoded.limit());
                    this.consumer.consume(this.line, this.lineMd5Digest.digest());
                }
            }
            catch (CharacterCodingException e) {
                throw new IllegalStateException("Error encoding line hash in file: " + this.file.getAbsolutePath(), e);
            }
        }
    }

    private static class FileHashComputer
    extends CharHandler {
        private MessageDigest globalMd5Digest = DigestUtils.getMd5Digest();
        private StringBuilder sb = new StringBuilder();
        private final CharsetEncoder encoder = StandardCharsets.UTF_8.newEncoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        private final File file;

        public FileHashComputer(File f) {
            this.file = f;
        }

        @Override
        protected void handleIgnoreEoL(char c) {
            this.sb.append(c);
        }

        @Override
        protected void newLine() {
            this.sb.append('\n');
            this.processBuffer();
            this.sb.setLength(0);
        }

        @Override
        protected void eof() {
            if (this.sb.length() > 0) {
                this.processBuffer();
            }
        }

        private void processBuffer() {
            try {
                if (this.sb.length() > 0) {
                    ByteBuffer encoded = this.encoder.encode(CharBuffer.wrap(this.sb));
                    this.globalMd5Digest.update(encoded.array(), 0, encoded.limit());
                }
            }
            catch (CharacterCodingException e) {
                throw new IllegalStateException("Error encoding line hash in file: " + this.file.getAbsolutePath(), e);
            }
        }

        @CheckForNull
        public String getHash() {
            return Hex.encodeHexString(this.globalMd5Digest.digest());
        }
    }

    private static class LineCounter
    extends CharHandler {
        private int lines = 1;
        private int nonBlankLines = 0;
        private boolean blankLine = true;
        boolean alreadyLoggedInvalidCharacter = false;
        private final File file;
        private final Charset encoding;

        LineCounter(File file, Charset encoding) {
            this.file = file;
            this.encoding = encoding;
        }

        @Override
        protected void handleAll(char c) {
            if (!this.alreadyLoggedInvalidCharacter && c == '\ufffd') {
                LOG.warn("Invalid character encountered in file {} at line {} for encoding {}. Please fix file content or configure the encoding to be used using property '{}'.", this.file, this.lines, this.encoding, "sonar.sourceEncoding");
                this.alreadyLoggedInvalidCharacter = true;
            }
        }

        @Override
        protected void newLine() {
            ++this.lines;
            if (!this.blankLine) {
                ++this.nonBlankLines;
            }
            this.blankLine = true;
        }

        @Override
        protected void handleIgnoreEoL(char c) {
            if (!Character.isWhitespace(c)) {
                this.blankLine = false;
            }
        }

        @Override
        protected void eof() {
            if (!this.blankLine) {
                ++this.nonBlankLines;
            }
        }

        public int lines() {
            return this.lines;
        }

        public int nonBlankLines() {
            return this.nonBlankLines;
        }
    }

    public static abstract class CharHandler {
        protected void handleAll(char c) {
        }

        protected void handleIgnoreEoL(char c) {
        }

        protected void newLine() {
        }

        protected void eof() {
        }
    }
}

