/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.sensor.duplication.internal;

import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.internal.DefaultInputFile;
import org.sonar.api.batch.sensor.duplication.Duplication;
import org.sonar.api.batch.sensor.duplication.NewDuplication;
import org.sonar.api.batch.sensor.internal.DefaultStorable;
import org.sonar.api.batch.sensor.internal.SensorStorage;
import org.sonar.api.internal.apachecommons.lang.builder.EqualsBuilder;
import org.sonar.api.internal.apachecommons.lang.builder.HashCodeBuilder;
import org.sonar.api.internal.apachecommons.lang.builder.ToStringBuilder;
import org.sonar.api.internal.apachecommons.lang.builder.ToStringStyle;
import org.sonar.api.internal.google.common.base.Preconditions;

public class DefaultDuplication
extends DefaultStorable
implements NewDuplication,
Duplication {
    private Duplication.Block originBlock;
    private List<Duplication.Block> duplicates = new LinkedList<Duplication.Block>();

    public DefaultDuplication() {
    }

    public DefaultDuplication(@Nullable SensorStorage storage) {
        super(storage);
    }

    @Override
    public DefaultDuplication originBlock(InputFile inputFile, int startLine, int endLine) {
        Preconditions.checkArgument(inputFile != null, "InputFile can't be null");
        this.validateLineArgument(inputFile, startLine, "startLine");
        this.validateLineArgument(inputFile, endLine, "endLine");
        this.originBlock = new Duplication.Block(((DefaultInputFile)inputFile).key(), startLine, endLine - startLine + 1);
        return this;
    }

    @Override
    public DefaultDuplication isDuplicatedBy(InputFile sameOrOtherFile, int startLine, int endLine) {
        Preconditions.checkArgument(sameOrOtherFile != null, "InputFile can't be null");
        this.validateLineArgument(sameOrOtherFile, startLine, "startLine");
        this.validateLineArgument(sameOrOtherFile, endLine, "endLine");
        return this.isDuplicatedBy(((DefaultInputFile)sameOrOtherFile).key(), startLine, endLine);
    }

    public DefaultDuplication isDuplicatedBy(String fileKey, int startLine, int endLine) {
        Preconditions.checkNotNull(this.originBlock, "Call originBlock() first");
        this.duplicates.add(new Duplication.Block(fileKey, startLine, endLine - startLine + 1));
        return this;
    }

    @Override
    public void doSave() {
        Preconditions.checkNotNull(this.originBlock, "Call originBlock() first");
        Preconditions.checkState(!this.duplicates.isEmpty(), "No duplicates. Call isDuplicatedBy()");
        this.storage.store(this);
    }

    @Override
    public Duplication.Block originBlock() {
        return this.originBlock;
    }

    public DefaultDuplication setOriginBlock(Duplication.Block originBlock) {
        this.originBlock = originBlock;
        return this;
    }

    @Override
    public List<Duplication.Block> duplicates() {
        return this.duplicates;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        DefaultDuplication rhs = (DefaultDuplication)obj;
        EqualsBuilder equalsBuilder = new EqualsBuilder().append(this.originBlock, rhs.originBlock).append(this.duplicates.size(), rhs.duplicates.size());
        if (this.duplicates.size() == rhs.duplicates.size()) {
            for (int i = 0; i < this.duplicates.size(); ++i) {
                equalsBuilder.append(this.duplicates.get(i), rhs.duplicates.get(i));
            }
        }
        return equalsBuilder.isEquals();
    }

    public int hashCode() {
        HashCodeBuilder hcBuilder = new HashCodeBuilder(17, 37).append(this.originBlock).append(this.duplicates.size());
        for (int i = 0; i < this.duplicates.size(); ++i) {
            hcBuilder.append(this.duplicates.get(i));
        }
        return hcBuilder.toHashCode();
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE).append("origin", this.originBlock).append("duplicates", this.duplicates, true).toString();
    }
}

