/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.issue.action;

import java.util.List;
import org.sonar.api.internal.google.common.base.Preconditions;
import org.sonar.api.internal.google.common.base.Strings;
import org.sonar.api.internal.google.common.collect.ImmutableList;
import org.sonar.api.internal.google.common.collect.Lists;
import org.sonar.api.issue.Issue;
import org.sonar.api.issue.action.Function;
import org.sonar.api.issue.condition.Condition;

public class Action {
    private final String key;
    private final List<Condition> conditions;
    private final List<Function> functions;

    Action(String key) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(key), "Action key must be set");
        this.key = key;
        this.conditions = Lists.newArrayList();
        this.functions = Lists.newArrayList();
    }

    public String key() {
        return this.key;
    }

    public Action setConditions(Condition ... conditions) {
        this.conditions.addAll(ImmutableList.copyOf(conditions));
        return this;
    }

    public List<Condition> conditions() {
        return this.conditions;
    }

    public Action setFunctions(Function ... functions) {
        this.functions.addAll(ImmutableList.copyOf(functions));
        return this;
    }

    public List<Function> functions() {
        return this.functions;
    }

    public boolean supports(Issue issue) {
        for (Condition condition : this.conditions) {
            if (condition.matches(issue)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Action that = (Action)o;
        return this.key.equals(that.key);
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public String toString() {
        return this.key;
    }
}

