/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.scan.filesystem;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.CheckForNull;
import org.sonar.api.batch.BatchSide;
import org.sonar.api.internal.google.common.base.Joiner;
import org.sonar.api.internal.google.common.base.Preconditions;
import org.sonar.api.utils.PathUtils;

@BatchSide
public class PathResolver {
    public File relativeFile(File dir, String path) {
        Preconditions.checkArgument(dir.isDirectory(), "Not a directory: " + dir.getAbsolutePath());
        File file = new File(path);
        if (!file.isAbsolute()) {
            try {
                file = new File(dir, path).getAbsoluteFile();
            }
            catch (Exception e) {
                throw new IllegalStateException("Fail to resolve path '" + path + "' relative to: " + dir.getAbsolutePath(), e);
            }
        }
        return file;
    }

    public List<File> relativeFiles(File dir, List<String> paths) {
        ArrayList<File> result = new ArrayList<File>();
        for (String path : paths) {
            result.add(this.relativeFile(dir, path));
        }
        return result;
    }

    @CheckForNull
    public RelativePath relativePath(Collection<File> dirs, File file) {
        ArrayList<String> stack = new ArrayList<String>();
        for (File cursor = file; cursor != null; cursor = cursor.getParentFile()) {
            File parentDir = PathResolver.parentDir(dirs, cursor);
            if (parentDir != null) {
                return new RelativePath(parentDir, Joiner.on("/").join(stack));
            }
            stack.add(0, cursor.getName());
        }
        return null;
    }

    @CheckForNull
    public String relativePath(File dir, File file) {
        ArrayList<String> stack = new ArrayList<String>();
        String dirPath = PathUtils.canonicalPath(dir);
        for (File cursor = file; cursor != null; cursor = cursor.getParentFile()) {
            if (dirPath.equals(PathUtils.canonicalPath(cursor))) {
                return Joiner.on("/").join(stack);
            }
            stack.add(0, cursor.getName());
        }
        return null;
    }

    @CheckForNull
    private static File parentDir(Collection<File> dirs, File cursor) {
        for (File dir : dirs) {
            if (!PathUtils.canonicalPath(dir).equals(PathUtils.canonicalPath(cursor))) continue;
            return dir;
        }
        return null;
    }

    public static final class RelativePath {
        private File dir;
        private String path;

        public RelativePath(File dir, String path) {
            this.dir = dir;
            this.path = path;
        }

        public File dir() {
            return this.dir;
        }

        public String path() {
            return this.path;
        }
    }
}

