/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.sonar.api.internal.google.common.annotations.Beta;
import org.sonar.api.utils.Version;

@Beta
public interface Plugin {
    public void define(Context var1);

    public static class Context {
        private final Version version;
        private final List extensions = new ArrayList();

        public Context(Version version) {
            this.version = version;
        }

        public Version getSonarQubeVersion() {
            return this.version;
        }

        public Context addExtension(Object extension) {
            Objects.requireNonNull(extension);
            this.extensions.add(extension);
            return this;
        }

        public Context addExtensions(Collection extensions) {
            this.extensions.addAll(extensions);
            return this;
        }

        public Context addExtensions(Object first, Object second, Object ... others) {
            this.addExtension(first);
            this.addExtension(second);
            this.addExtensions(Arrays.asList(others));
            return this;
        }

        public List getExtensions() {
            return this.extensions;
        }
    }
}

