/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.utils.command;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.sonar.api.internal.apachecommons.lang.StringUtils;
import org.sonar.api.internal.google.common.base.Joiner;
import org.sonar.api.internal.google.common.base.Preconditions;
import org.sonar.api.internal.google.common.collect.ImmutableList;
import org.sonar.api.internal.google.common.collect.ImmutableMap;
import org.sonar.api.internal.google.common.collect.Maps;
import org.sonar.api.utils.System2;

public class Command {
    private final String executable;
    private final List<String> arguments = new ArrayList<String>();
    private final List<String> argumentsForLogs = new ArrayList<String>();
    private final Map<String, String> env;
    private File directory;
    private boolean newShell = false;
    private final System2 system;

    Command(String executable, System2 system) {
        Preconditions.checkArgument(!StringUtils.isBlank(executable), "Command executable can not be blank");
        this.executable = executable;
        this.env = Maps.newHashMap(system.envVariables());
        this.system = system;
    }

    public static Command create(String executable) {
        return new Command(executable, System2.INSTANCE);
    }

    public String getExecutable() {
        return this.executable;
    }

    public List<String> getArguments() {
        return ImmutableList.copyOf(this.arguments);
    }

    public Command addArgument(String arg) {
        this.arguments.add(arg);
        this.argumentsForLogs.add(arg);
        return this;
    }

    public Command addMaskedArgument(String arg) {
        this.arguments.add(arg);
        this.argumentsForLogs.add("********");
        return this;
    }

    public Command addArguments(List<String> args) {
        this.arguments.addAll(args);
        this.argumentsForLogs.addAll(args);
        return this;
    }

    public Command addArguments(String[] args) {
        Collections.addAll(this.arguments, args);
        Collections.addAll(this.argumentsForLogs, args);
        return this;
    }

    public File getDirectory() {
        return this.directory;
    }

    public Command setDirectory(File d) {
        this.directory = d;
        return this;
    }

    public Command setEnvironmentVariable(String name, String value) {
        this.env.put(name, value);
        return this;
    }

    public Map<String, String> getEnvironmentVariables() {
        return ImmutableMap.copyOf(this.env);
    }

    public boolean isNewShell() {
        return this.newShell;
    }

    public Command setNewShell(boolean b) {
        this.newShell = b;
        return this;
    }

    List<String> toStrings(boolean forLogs) {
        ImmutableList.Builder command = ImmutableList.builder();
        if (this.newShell) {
            if (this.system.isOsWindows()) {
                command.add(new String[]{"cmd", "/C", "call"});
            } else {
                command.add("sh");
            }
        }
        command.add(this.executable);
        command.addAll(forLogs ? this.argumentsForLogs : this.arguments);
        return command.build();
    }

    public String toCommandLine() {
        return Joiner.on(" ").join(this.toStrings(false));
    }

    public String toString() {
        return Joiner.on(" ").join(this.toStrings(true));
    }
}

