/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.server.authentication;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.sonar.api.internal.google.common.base.Charsets;

public class UnauthorizedException
extends RuntimeException {
    public static final String UNAUTHORIZED_PATH = "/sessions/unauthorized";
    private static final String UNAUTHORIZED_PATH_WITH_MESSAGE = "/sessions/unauthorized?message=%s";

    public UnauthorizedException(String message) {
        super(message);
    }

    public UnauthorizedException(String message, Throwable cause) {
        super(message, cause);
    }

    public String getPath() {
        return String.format(UNAUTHORIZED_PATH_WITH_MESSAGE, UnauthorizedException.encodeMessage(this.getMessage()));
    }

    private static String encodeMessage(String message) {
        try {
            return URLEncoder.encode(message, Charsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException unsupportedException) {
            throw new IllegalStateException(String.format("Fail to encode %s", message), unsupportedException);
        }
    }
}

