/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.web;

import java.util.ArrayList;
import java.util.List;
import org.sonar.api.internal.google.common.base.Preconditions;
import org.sonar.api.web.Criterion;
import org.sonar.api.web.FilterColumn;

public final class Filter {
    public static final String LIST = "list";
    public static final String TREEMAP = "treemap";
    private boolean favouritesOnly;
    private String displayAs = "list";
    private int pageSize;
    private List<Criterion> criteria = new ArrayList<Criterion>();
    private List<FilterColumn> columns = new ArrayList<FilterColumn>();

    private Filter() {
    }

    public static Filter create() {
        return new Filter();
    }

    public List<Criterion> getCriteria() {
        return this.criteria;
    }

    public Filter add(Criterion criterion) {
        this.criteria.add(criterion);
        return this;
    }

    public List<FilterColumn> getColumns() {
        return this.columns;
    }

    public Filter add(FilterColumn column) {
        this.columns.add(column);
        return this;
    }

    public boolean isFavouritesOnly() {
        return this.favouritesOnly;
    }

    public Filter setFavouritesOnly(boolean favouritesOnly) {
        this.favouritesOnly = favouritesOnly;
        return this;
    }

    public String getDisplayAs() {
        return this.displayAs;
    }

    public Filter setDisplayAs(String displayAs) {
        Preconditions.checkArgument(LIST.equals(displayAs) || TREEMAP.equals(displayAs), "Default display should be either %s or %s, not %s", LIST, TREEMAP, displayAs);
        this.displayAs = displayAs;
        return this;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public Filter setPageSize(int pageSize) {
        Preconditions.checkArgument(pageSize >= 20 && pageSize <= 200, "page size should be between 20 and 200");
        this.pageSize = pageSize;
        return this;
    }
}

