/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.measures;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import org.sonar.api.measures.Metric;
import org.sonar.api.utils.SonarException;

public final class CoreMetrics {
    public static String DOMAIN_SIZE = "Size";
    public static String DOMAIN_COVERAGE = "Coverage";
    @Deprecated
    public static String DOMAIN_TESTS = "Tests";
    @Deprecated
    public static String DOMAIN_INTEGRATION_TESTS = "Tests (Integration)";
    @Deprecated
    public static String DOMAIN_OVERALL_TESTS = "Tests (Overall)";
    public static String DOMAIN_COMPLEXITY = "Complexity";
    public static String DOMAIN_DOCUMENTATION = "Documentation";
    public static String DOMAIN_SCM = "SCM";
    public static String DOMAIN_ISSUES = "Issues";
    public static String DOMAIN_GENERAL = "General";
    public static String DOMAIN_DUPLICATIONS = "Duplications";
    @Deprecated
    public static String DOMAIN_DUPLICATION = "Duplication";
    public static String DOMAIN_DESIGN = "Design";
    public static String DOMAIN_MAINTAINABILITY = "Maintainability";
    public static String DOMAIN_RELIABILITY = "Reliability";
    public static String DOMAIN_SECURITY = "Security";
    @Deprecated
    public static String DOMAIN_TECHNICAL_DEBT = "Technical Debt";
    public static String DOMAIN_RELEASABILITY = "Releasability";
    public static final String LINES_KEY = "lines";
    public static final Metric<Integer> LINES = new Metric.Builder("lines", "Lines", Metric.ValueType.INT).setDescription("Lines").setDirection(-1).setQualitative(false).setDomain(DOMAIN_SIZE).create();
    public static final String GENERATED_LINES_KEY = "generated_lines";
    public static final Metric<Integer> GENERATED_LINES = new Metric.Builder("generated_lines", "Generated Lines", Metric.ValueType.INT).setDescription("Number of generated lines").setDirection(-1).setQualitative(false).setDomain(DOMAIN_SIZE).setBestValue(0.0).setOptimizedBestValue(true).create();
    public static final String NCLOC_KEY = "ncloc";
    public static final Metric<Integer> NCLOC = new Metric.Builder("ncloc", "Lines of Code", Metric.ValueType.INT).setDescription("Non commenting lines of code").setDirection(-1).setQualitative(false).setDomain(DOMAIN_SIZE).create();
    public static final String NEW_LINES_KEY = "new_lines";
    public static final Metric<Integer> NEW_LINES = new Metric.Builder("new_lines", "Lines on New Code", Metric.ValueType.INT).setDescription("Non commenting lines on new code").setDirection(-1).setQualitative(false).setDomain(DOMAIN_SIZE).setDeleteHistoricalData(true).create();
    public static final String NCLOC_LANGUAGE_DISTRIBUTION_KEY = "ncloc_language_distribution";
    public static final Metric<String> NCLOC_LANGUAGE_DISTRIBUTION = new Metric.Builder("ncloc_language_distribution", "Lines of Code Per Language", Metric.ValueType.DATA).setDescription("Non Commenting Lines of Code Distributed By Language").setDirection(-1).setQualitative(false).setDomain(DOMAIN_SIZE).create();
    public static final String GENERATED_NCLOC_KEY = "generated_ncloc";
    public static final Metric<Integer> GENERATED_NCLOC = new Metric.Builder("generated_ncloc", "Generated Lines of Code", Metric.ValueType.INT).setDescription("Generated non Commenting Lines of Code").setDirection(-1).setQualitative(false).setDomain(DOMAIN_SIZE).setBestValue(0.0).setOptimizedBestValue(true).create();
    public static final String CLASSES_KEY = "classes";
    public static final Metric<Integer> CLASSES = new Metric.Builder("classes", "Classes", Metric.ValueType.INT).setDescription("Classes").setDirection(-1).setQualitative(false).setDomain(DOMAIN_SIZE).create();
    public static final String FILES_KEY = "files";
    public static final Metric<Integer> FILES = new Metric.Builder("files", "Files", Metric.ValueType.INT).setDescription("Number of files").setDirection(-1).setQualitative(false).setDomain(DOMAIN_SIZE).create();
    public static final String DIRECTORIES_KEY = "directories";
    public static final Metric<Integer> DIRECTORIES = new Metric.Builder("directories", "Directories", Metric.ValueType.INT).setDescription("Directories").setDirection(-1).setQualitative(false).setDomain(DOMAIN_SIZE).create();
    public static final String FUNCTIONS_KEY = "functions";
    public static final Metric<Integer> FUNCTIONS = new Metric.Builder("functions", "Functions", Metric.ValueType.INT).setDescription("Functions").setDirection(-1).setQualitative(false).setDomain(DOMAIN_SIZE).create();
    @Deprecated
    public static final String ACCESSORS_KEY = "accessors";
    @Deprecated
    public static final Metric<Integer> ACCESSORS = new Metric.Builder("accessors", "Accessors", Metric.ValueType.INT).setDescription("Accessors").setDirection(-1).setQualitative(false).setDomain(DOMAIN_SIZE).setHidden(true).create();
    public static final String STATEMENTS_KEY = "statements";
    public static final Metric<Integer> STATEMENTS = new Metric.Builder("statements", "Statements", Metric.ValueType.INT).setDescription("Number of statements").setDirection(-1).setQualitative(false).setDomain(DOMAIN_SIZE).create();
    public static final String PUBLIC_API_KEY = "public_api";
    public static final Metric<Integer> PUBLIC_API = new Metric.Builder("public_api", "Public API", Metric.ValueType.INT).setDescription("Public API").setDirection(-1).setQualitative(false).setDomain(DOMAIN_DOCUMENTATION).create();
    public static final String PROJECTS_KEY = "projects";
    public static final Metric<Integer> PROJECTS = new Metric.Builder("projects", "Projects", Metric.ValueType.INT).setDescription("Number of projects").setDirection(-1).setQualitative(false).setDomain(DOMAIN_SIZE).create();
    public static final String COMMENT_LINES_KEY = "comment_lines";
    public static final Metric<Integer> COMMENT_LINES = new Metric.Builder("comment_lines", "Comment Lines", Metric.ValueType.INT).setDescription("Number of comment lines").setDirection(1).setQualitative(false).setDomain(DOMAIN_DOCUMENTATION).create();
    public static final String COMMENT_LINES_DENSITY_KEY = "comment_lines_density";
    public static final Metric<Double> COMMENT_LINES_DENSITY = new Metric.Builder("comment_lines_density", "Comments (%)", Metric.ValueType.PERCENT).setDescription("Comments balanced by ncloc + comment lines").setDirection(1).setQualitative(true).setDomain(DOMAIN_DOCUMENTATION).create();
    public static final String PUBLIC_DOCUMENTED_API_DENSITY_KEY = "public_documented_api_density";
    public static final Metric<Double> PUBLIC_DOCUMENTED_API_DENSITY = new Metric.Builder("public_documented_api_density", "Public Documented API (%)", Metric.ValueType.PERCENT).setDescription("Public documented classes and functions balanced by ncloc").setDirection(1).setQualitative(true).setDomain(DOMAIN_DOCUMENTATION).setWorstValue(0.0).setBestValue(100.0).setOptimizedBestValue(true).create();
    public static final String PUBLIC_UNDOCUMENTED_API_KEY = "public_undocumented_api";
    public static final Metric<Integer> PUBLIC_UNDOCUMENTED_API = new Metric.Builder("public_undocumented_api", "Public Undocumented API", Metric.ValueType.INT).setDescription("Public undocumented classes, functions and variables").setDirection(-1).setQualitative(true).setDomain(DOMAIN_DOCUMENTATION).setBestValue(0.0).setDirection(-1).setOptimizedBestValue(true).create();
    @Deprecated
    public static final String COMMENTED_OUT_CODE_LINES_KEY = "commented_out_code_lines";
    @Deprecated
    public static final Metric<Integer> COMMENTED_OUT_CODE_LINES = new Metric.Builder("commented_out_code_lines", "Commented-Out LOC", Metric.ValueType.INT).setDescription("Commented lines of code").setDirection(-1).setQualitative(true).setDomain(DOMAIN_DOCUMENTATION).setBestValue(0.0).setOptimizedBestValue(true).setHidden(true).create();
    public static final String COMPLEXITY_KEY = "complexity";
    public static final Metric<Integer> COMPLEXITY = new Metric.Builder("complexity", "Complexity", Metric.ValueType.INT).setDescription("Cyclomatic complexity").setDirection(-1).setQualitative(false).setDomain(DOMAIN_COMPLEXITY).create();
    public static final String FILE_COMPLEXITY_KEY = "file_complexity";
    public static final Metric<Double> FILE_COMPLEXITY = new Metric.Builder("file_complexity", "Complexity / File", Metric.ValueType.FLOAT).setDescription("Complexity average by file").setDirection(-1).setQualitative(true).setDomain(DOMAIN_COMPLEXITY).create();
    public static final String COMPLEXITY_IN_CLASSES_KEY = "complexity_in_classes";
    public static final Metric<Integer> COMPLEXITY_IN_CLASSES = new Metric.Builder("complexity_in_classes", "Complexity in Classes", Metric.ValueType.INT).setDescription("Cyclomatic complexity in classes").setHidden(true).setDirection(-1).setQualitative(false).setDomain(DOMAIN_COMPLEXITY).setDeleteHistoricalData(true).create();
    public static final String CLASS_COMPLEXITY_KEY = "class_complexity";
    public static final Metric<Double> CLASS_COMPLEXITY = new Metric.Builder("class_complexity", "Complexity / Class", Metric.ValueType.FLOAT).setDescription("Complexity average by class").setDirection(-1).setQualitative(true).setDomain(DOMAIN_COMPLEXITY).create();
    public static final String COMPLEXITY_IN_FUNCTIONS_KEY = "complexity_in_functions";
    public static final Metric<Integer> COMPLEXITY_IN_FUNCTIONS = new Metric.Builder("complexity_in_functions", "Complexity in Functions", Metric.ValueType.INT).setDescription("Cyclomatic complexity in functions").setHidden(true).setDirection(-1).setQualitative(false).setDomain(DOMAIN_COMPLEXITY).setDeleteHistoricalData(true).create();
    public static final String FUNCTION_COMPLEXITY_KEY = "function_complexity";
    public static final Metric<Double> FUNCTION_COMPLEXITY = new Metric.Builder("function_complexity", "Complexity / Function", Metric.ValueType.FLOAT).setDescription("Complexity average by function").setDirection(-1).setQualitative(true).setDomain(DOMAIN_COMPLEXITY).create();
    @Deprecated
    public static final String CLASS_COMPLEXITY_DISTRIBUTION_KEY = "class_complexity_distribution";
    @Deprecated
    public static final Metric<String> CLASS_COMPLEXITY_DISTRIBUTION = new Metric.Builder("class_complexity_distribution", "Class Distribution / Complexity", Metric.ValueType.DISTRIB).setDescription("Classes distribution /complexity").setDirection(0).setQualitative(true).setDomain(DOMAIN_COMPLEXITY).setHidden(true).create();
    public static final String FUNCTION_COMPLEXITY_DISTRIBUTION_KEY = "function_complexity_distribution";
    public static final Metric<String> FUNCTION_COMPLEXITY_DISTRIBUTION = new Metric.Builder("function_complexity_distribution", "Function Distribution / Complexity", Metric.ValueType.DISTRIB).setDescription("Functions distribution /complexity").setDirection(0).setQualitative(true).setDomain(DOMAIN_COMPLEXITY).create();
    public static final String FILE_COMPLEXITY_DISTRIBUTION_KEY = "file_complexity_distribution";
    public static final Metric<String> FILE_COMPLEXITY_DISTRIBUTION = new Metric.Builder("file_complexity_distribution", "File Distribution / Complexity", Metric.ValueType.DISTRIB).setDescription("Files distribution /complexity").setDirection(0).setQualitative(true).setDomain(DOMAIN_COMPLEXITY).create();
    public static final String TESTS_KEY = "tests";
    public static final Metric<Integer> TESTS = new Metric.Builder("tests", "Unit Tests", Metric.ValueType.INT).setDescription("Number of unit tests").setDirection(-1).setQualitative(false).setDomain(DOMAIN_COVERAGE).create();
    public static final String TEST_EXECUTION_TIME_KEY = "test_execution_time";
    public static final Metric<Long> TEST_EXECUTION_TIME = new Metric.Builder("test_execution_time", "Unit Test Duration", Metric.ValueType.MILLISEC).setDescription("Execution duration of unit tests").setDirection(-1).setQualitative(false).setDomain(DOMAIN_COVERAGE).create();
    public static final String TEST_ERRORS_KEY = "test_errors";
    public static final Metric<Integer> TEST_ERRORS = new Metric.Builder("test_errors", "Unit Test Errors", Metric.ValueType.INT).setDescription("Number of unit test errors").setDirection(-1).setQualitative(true).setDomain(DOMAIN_COVERAGE).setBestValue(0.0).setOptimizedBestValue(true).create();
    public static final String SKIPPED_TESTS_KEY = "skipped_tests";
    public static final Metric<Integer> SKIPPED_TESTS = new Metric.Builder("skipped_tests", "Skipped Unit Tests", Metric.ValueType.INT).setDescription("Number of skipped unit tests").setDirection(-1).setQualitative(true).setDomain(DOMAIN_COVERAGE).setBestValue(0.0).setOptimizedBestValue(true).create();
    public static final String TEST_FAILURES_KEY = "test_failures";
    public static final Metric<Integer> TEST_FAILURES = new Metric.Builder("test_failures", "Unit Test Failures", Metric.ValueType.INT).setDescription("Number of unit test failures").setDirection(-1).setQualitative(true).setDomain(DOMAIN_COVERAGE).setBestValue(0.0).setOptimizedBestValue(true).create();
    public static final String TEST_SUCCESS_DENSITY_KEY = "test_success_density";
    public static final Metric<Double> TEST_SUCCESS_DENSITY = new Metric.Builder("test_success_density", "Unit Test Success (%)", Metric.ValueType.PERCENT).setDescription("Density of successful unit tests").setDirection(1).setQualitative(true).setDomain(DOMAIN_COVERAGE).setWorstValue(0.0).setBestValue(100.0).setOptimizedBestValue(true).create();
    @Deprecated
    public static final String TEST_DATA_KEY = "test_data";
    @Deprecated
    public static final Metric<String> TEST_DATA = new Metric.Builder("test_data", "Unit Test Details", Metric.ValueType.DATA).setDescription("Unit tests details").setDirection(-1).setDomain(DOMAIN_COVERAGE).create();
    public static final String COVERAGE_KEY = "coverage";
    public static final Metric<Double> COVERAGE = new Metric.Builder("coverage", "Coverage", Metric.ValueType.PERCENT).setDescription("Coverage by unit tests").setDirection(1).setQualitative(true).setDomain(DOMAIN_COVERAGE).setWorstValue(0.0).setBestValue(100.0).create();
    public static final String NEW_COVERAGE_KEY = "new_coverage";
    public static final Metric<Double> NEW_COVERAGE = new Metric.Builder("new_coverage", "Coverage on New Code", Metric.ValueType.PERCENT).setDescription("Coverage of new/changed code").setDirection(1).setQualitative(true).setDomain(DOMAIN_COVERAGE).setWorstValue(0.0).setBestValue(100.0).setDeleteHistoricalData(true).create();
    public static final String LINES_TO_COVER_KEY = "lines_to_cover";
    public static final Metric<Integer> LINES_TO_COVER = new Metric.Builder("lines_to_cover", "Lines to Cover", Metric.ValueType.INT).setDescription("Lines to cover").setDirection(1).setQualitative(false).setDomain(DOMAIN_COVERAGE).create();
    public static final String NEW_LINES_TO_COVER_KEY = "new_lines_to_cover";
    public static final Metric<Integer> NEW_LINES_TO_COVER = new Metric.Builder("new_lines_to_cover", "Lines to Cover on New Code", Metric.ValueType.INT).setDescription("Lines to cover on new code").setDirection(-1).setQualitative(false).setDomain(DOMAIN_COVERAGE).setDeleteHistoricalData(true).create();
    public static final String UNCOVERED_LINES_KEY = "uncovered_lines";
    public static final Metric<Integer> UNCOVERED_LINES = new Metric.Builder("uncovered_lines", "Uncovered Lines", Metric.ValueType.INT).setDescription("Uncovered lines").setDirection(-1).setDomain(DOMAIN_COVERAGE).setBestValue(0.0).create();
    public static final String NEW_UNCOVERED_LINES_KEY = "new_uncovered_lines";
    public static final Metric<Integer> NEW_UNCOVERED_LINES = new Metric.Builder("new_uncovered_lines", "Uncovered Lines on New Code", Metric.ValueType.INT).setDescription("Uncovered lines on new code").setDirection(-1).setDomain(DOMAIN_COVERAGE).setBestValue(0.0).setDeleteHistoricalData(true).create();
    public static final String LINE_COVERAGE_KEY = "line_coverage";
    public static final Metric<Double> LINE_COVERAGE = new Metric.Builder("line_coverage", "Line Coverage", Metric.ValueType.PERCENT).setDescription("Line coverage").setDirection(1).setQualitative(true).setDomain(DOMAIN_COVERAGE).setWorstValue(0.0).setBestValue(100.0).create();
    public static final String NEW_LINE_COVERAGE_KEY = "new_line_coverage";
    public static final Metric<Double> NEW_LINE_COVERAGE = new Metric.Builder("new_line_coverage", "Line Coverage on New Code", Metric.ValueType.PERCENT).setDescription("Line coverage of added/changed code").setDirection(1).setQualitative(true).setWorstValue(0.0).setBestValue(100.0).setDomain(DOMAIN_COVERAGE).setDeleteHistoricalData(true).create();
    @Deprecated
    public static final String COVERAGE_LINE_HITS_DATA_KEY = "coverage_line_hits_data";
    @Deprecated
    public static final Metric<String> COVERAGE_LINE_HITS_DATA = new Metric.Builder("coverage_line_hits_data", "Coverage Hits by Line", Metric.ValueType.DATA).setDescription("Coverage hits by line").setDomain(DOMAIN_COVERAGE).setDeleteHistoricalData(true).create();
    public static final String CONDITIONS_TO_COVER_KEY = "conditions_to_cover";
    public static final Metric<Integer> CONDITIONS_TO_COVER = new Metric.Builder("conditions_to_cover", "Branches to Cover", Metric.ValueType.INT).setDescription("Branches to cover").setDomain(DOMAIN_COVERAGE).setHidden(true).create();
    public static final String NEW_CONDITIONS_TO_COVER_KEY = "new_conditions_to_cover";
    public static final Metric<Integer> NEW_CONDITIONS_TO_COVER = new Metric.Builder("new_conditions_to_cover", "Branches to Cover on New Code", Metric.ValueType.INT).setDescription("Branches to cover on New Code").setDomain(DOMAIN_COVERAGE).setDeleteHistoricalData(true).setHidden(true).create();
    public static final String UNCOVERED_CONDITIONS_KEY = "uncovered_conditions";
    public static final Metric<Integer> UNCOVERED_CONDITIONS = new Metric.Builder("uncovered_conditions", "Uncovered Conditions", Metric.ValueType.INT).setDescription("Uncovered conditions").setDirection(-1).setDomain(DOMAIN_COVERAGE).setBestValue(0.0).create();
    public static final String NEW_UNCOVERED_CONDITIONS_KEY = "new_uncovered_conditions";
    public static final Metric<Integer> NEW_UNCOVERED_CONDITIONS = new Metric.Builder("new_uncovered_conditions", "Uncovered Conditions on New Code", Metric.ValueType.INT).setDescription("Uncovered conditions on new code").setDirection(-1).setDomain(DOMAIN_COVERAGE).setBestValue(0.0).setDeleteHistoricalData(true).create();
    public static final String BRANCH_COVERAGE_KEY = "branch_coverage";
    public static final Metric<Double> BRANCH_COVERAGE = new Metric.Builder("branch_coverage", "Condition Coverage", Metric.ValueType.PERCENT).setDescription("Condition coverage").setDirection(1).setQualitative(true).setDomain(DOMAIN_COVERAGE).setWorstValue(0.0).setBestValue(100.0).create();
    public static final String NEW_BRANCH_COVERAGE_KEY = "new_branch_coverage";
    public static final Metric<Double> NEW_BRANCH_COVERAGE = new Metric.Builder("new_branch_coverage", "Condition Coverage on New Code", Metric.ValueType.PERCENT).setDescription("Condition coverage of new/changed code").setDirection(1).setQualitative(true).setDomain(DOMAIN_COVERAGE).setWorstValue(0.0).setBestValue(100.0).setDeleteHistoricalData(true).create();
    @Deprecated
    public static final String CONDITIONS_BY_LINE_KEY = "conditions_by_line";
    @Deprecated
    public static final Metric<String> CONDITIONS_BY_LINE = new Metric.Builder("conditions_by_line", "Conditions by Line", Metric.ValueType.DATA).setDescription("Conditions by line").setDomain(DOMAIN_COVERAGE).setDeleteHistoricalData(true).create();
    @Deprecated
    public static final String COVERED_CONDITIONS_BY_LINE_KEY = "covered_conditions_by_line";
    @Deprecated
    public static final Metric<String> COVERED_CONDITIONS_BY_LINE = new Metric.Builder("covered_conditions_by_line", "Covered Conditions by Line", Metric.ValueType.DATA).setDescription("Covered conditions by line").setDomain(DOMAIN_COVERAGE).setDeleteHistoricalData(true).create();
    public static final String IT_COVERAGE_KEY = "it_coverage";
    public static final Metric<Double> IT_COVERAGE = new Metric.Builder("it_coverage", "IT Coverage", Metric.ValueType.PERCENT).setDescription("Integration tests coverage").setDirection(1).setQualitative(true).setDomain(DOMAIN_COVERAGE).setWorstValue(0.0).setBestValue(100.0).create();
    public static final String NEW_IT_COVERAGE_KEY = "new_it_coverage";
    public static final Metric<Double> NEW_IT_COVERAGE = new Metric.Builder("new_it_coverage", "Coverage by IT on New Code", Metric.ValueType.PERCENT).setDescription("Integration tests coverage of new/changed code").setDirection(1).setQualitative(true).setDomain(DOMAIN_COVERAGE).setWorstValue(0.0).setBestValue(100.0).setDeleteHistoricalData(true).create();
    public static final String IT_LINES_TO_COVER_KEY = "it_lines_to_cover";
    public static final Metric<Integer> IT_LINES_TO_COVER = new Metric.Builder("it_lines_to_cover", "IT Lines to Cover", Metric.ValueType.INT).setDescription("Lines to cover by Integration Tests").setDirection(1).setDomain(DOMAIN_COVERAGE).setQualitative(false).setHidden(true).create();
    public static final String NEW_IT_LINES_TO_COVER_KEY = "new_it_lines_to_cover";
    public static final Metric<Integer> NEW_IT_LINES_TO_COVER = new Metric.Builder("new_it_lines_to_cover", "Lines to Cover by IT on New Code", Metric.ValueType.INT).setDescription("Lines to cover on new code by integration tests").setDirection(-1).setQualitative(false).setDomain(DOMAIN_COVERAGE).setDeleteHistoricalData(true).create();
    public static final String IT_UNCOVERED_LINES_KEY = "it_uncovered_lines";
    public static final Metric<Integer> IT_UNCOVERED_LINES = new Metric.Builder("it_uncovered_lines", "IT Uncovered Lines", Metric.ValueType.INT).setDescription("Uncovered lines by integration tests").setDirection(-1).setQualitative(false).setDomain(DOMAIN_COVERAGE).create();
    public static final String NEW_IT_UNCOVERED_LINES_KEY = "new_it_uncovered_lines";
    public static final Metric<Integer> NEW_IT_UNCOVERED_LINES = new Metric.Builder("new_it_uncovered_lines", "Uncovered Lines by IT on New Code", Metric.ValueType.INT).setDescription("New lines that are not covered by integration tests").setDirection(-1).setDomain(DOMAIN_COVERAGE).setBestValue(0.0).setDeleteHistoricalData(true).create();
    public static final String IT_LINE_COVERAGE_KEY = "it_line_coverage";
    public static final Metric<Double> IT_LINE_COVERAGE = new Metric.Builder("it_line_coverage", "IT Line Coverage", Metric.ValueType.PERCENT).setDescription("Line coverage by integration tests").setDirection(1).setQualitative(true).setDomain(DOMAIN_COVERAGE).create();
    public static final String NEW_IT_LINE_COVERAGE_KEY = "new_it_line_coverage";
    public static final Metric<Double> NEW_IT_LINE_COVERAGE = new Metric.Builder("new_it_line_coverage", "Line Coverage by IT on New Code", Metric.ValueType.PERCENT).setDescription("Integration tests line coverage of added/changed code").setDirection(1).setQualitative(true).setWorstValue(0.0).setBestValue(100.0).setDomain(DOMAIN_COVERAGE).setDeleteHistoricalData(true).create();
    @Deprecated
    public static final String IT_COVERAGE_LINE_HITS_DATA_KEY = "it_coverage_line_hits_data";
    @Deprecated
    public static final Metric<String> IT_COVERAGE_LINE_HITS_DATA = new Metric.Builder("it_coverage_line_hits_data", "IT Coverage Hits by Line", Metric.ValueType.DATA).setDescription("Coverage hits by line by integration tests").setDirection(0).setQualitative(false).setDomain(DOMAIN_COVERAGE).setDeleteHistoricalData(true).create();
    public static final String IT_CONDITIONS_TO_COVER_KEY = "it_conditions_to_cover";
    public static final Metric<Integer> IT_CONDITIONS_TO_COVER = new Metric.Builder("it_conditions_to_cover", "IT Branches to Cover", Metric.ValueType.INT).setDescription("Integration Tests conditions to cover").setDirection(1).setQualitative(false).setDomain(DOMAIN_COVERAGE).setHidden(true).create();
    public static final String NEW_IT_CONDITIONS_TO_COVER_KEY = "new_it_conditions_to_cover";
    public static final Metric<Integer> NEW_IT_CONDITIONS_TO_COVER = new Metric.Builder("new_it_conditions_to_cover", "Branches to Cover by IT on New Code", Metric.ValueType.INT).setDescription("Branches to cover by Integration Tests on New Code").setDomain(DOMAIN_COVERAGE).setDeleteHistoricalData(true).setHidden(true).create();
    public static final String IT_UNCOVERED_CONDITIONS_KEY = "it_uncovered_conditions";
    public static final Metric<Integer> IT_UNCOVERED_CONDITIONS = new Metric.Builder("it_uncovered_conditions", "IT Uncovered Conditions", Metric.ValueType.INT).setDescription("Uncovered conditions by integration tests").setDirection(-1).setDomain(DOMAIN_COVERAGE).create();
    public static final String NEW_IT_UNCOVERED_CONDITIONS_KEY = "new_it_uncovered_conditions";
    public static final Metric<Integer> NEW_IT_UNCOVERED_CONDITIONS = new Metric.Builder("new_it_uncovered_conditions", "Uncovered Conditions by IT on New Code", Metric.ValueType.INT).setDescription("New conditions that are not covered by integration tests").setDirection(-1).setDomain(DOMAIN_COVERAGE).setBestValue(0.0).setDeleteHistoricalData(true).create();
    public static final String IT_BRANCH_COVERAGE_KEY = "it_branch_coverage";
    public static final Metric<Double> IT_BRANCH_COVERAGE = new Metric.Builder("it_branch_coverage", "IT Condition Coverage", Metric.ValueType.PERCENT).setDescription("Condition coverage by integration tests").setDirection(1).setQualitative(true).setDomain(DOMAIN_COVERAGE).setWorstValue(0.0).setBestValue(100.0).create();
    public static final String NEW_IT_BRANCH_COVERAGE_KEY = "new_it_branch_coverage";
    public static final Metric<Double> NEW_IT_BRANCH_COVERAGE = new Metric.Builder("new_it_branch_coverage", "Condition Coverage by IT on New Code", Metric.ValueType.PERCENT).setDescription("Integration tests condition coverage of new/changed code").setDirection(1).setQualitative(true).setDomain(DOMAIN_COVERAGE).setWorstValue(0.0).setBestValue(100.0).setDeleteHistoricalData(true).create();
    @Deprecated
    public static final String IT_CONDITIONS_BY_LINE_KEY = "it_conditions_by_line";
    @Deprecated
    public static final Metric<String> IT_CONDITIONS_BY_LINE = new Metric.Builder("it_conditions_by_line", "IT Conditions by Line", Metric.ValueType.DATA).setDescription("IT conditions by line").setDomain(DOMAIN_COVERAGE).setDeleteHistoricalData(true).create();
    @Deprecated
    public static final String IT_COVERED_CONDITIONS_BY_LINE_KEY = "it_covered_conditions_by_line";
    @Deprecated
    public static final Metric<String> IT_COVERED_CONDITIONS_BY_LINE = new Metric.Builder("it_covered_conditions_by_line", "IT Covered Conditions by Line", Metric.ValueType.DATA).setDescription("IT covered conditions by line").setDomain(DOMAIN_COVERAGE).setDeleteHistoricalData(true).create();
    public static final String OVERALL_COVERAGE_KEY = "overall_coverage";
    public static final Metric<Double> OVERALL_COVERAGE = new Metric.Builder("overall_coverage", "Overall Coverage", Metric.ValueType.PERCENT).setDescription("Overall test coverage").setDirection(1).setQualitative(true).setDomain(DOMAIN_COVERAGE).setWorstValue(0.0).setBestValue(100.0).create();
    public static final String NEW_OVERALL_COVERAGE_KEY = "new_overall_coverage";
    public static final Metric<Double> NEW_OVERALL_COVERAGE = new Metric.Builder("new_overall_coverage", "Overall Coverage on New Code", Metric.ValueType.PERCENT).setDescription("Overall coverage of new/changed code").setDirection(1).setQualitative(true).setDomain(DOMAIN_COVERAGE).setWorstValue(0.0).setBestValue(100.0).setDeleteHistoricalData(true).create();
    public static final String OVERALL_LINES_TO_COVER_KEY = "overall_lines_to_cover";
    public static final Metric<Integer> OVERALL_LINES_TO_COVER = new Metric.Builder("overall_lines_to_cover", "Overall Lines to Cover", Metric.ValueType.INT).setDescription("Overall lines to cover by all tests").setDirection(1).setDomain(DOMAIN_COVERAGE).setQualitative(false).setHidden(true).create();
    public static final String NEW_OVERALL_LINES_TO_COVER_KEY = "new_overall_lines_to_cover";
    public static final Metric<Integer> NEW_OVERALL_LINES_TO_COVER = new Metric.Builder("new_overall_lines_to_cover", "Overall Lines to Cover on New Code", Metric.ValueType.INT).setDescription("New lines to cover by all tests").setDirection(-1).setQualitative(false).setDomain(DOMAIN_COVERAGE).setDeleteHistoricalData(true).create();
    public static final String OVERALL_UNCOVERED_LINES_KEY = "overall_uncovered_lines";
    public static final Metric<Integer> OVERALL_UNCOVERED_LINES = new Metric.Builder("overall_uncovered_lines", "Overall Uncovered Lines", Metric.ValueType.INT).setDescription("Uncovered lines by all tests").setDirection(-1).setQualitative(false).setDomain(DOMAIN_COVERAGE).create();
    public static final String NEW_OVERALL_UNCOVERED_LINES_KEY = "new_overall_uncovered_lines";
    public static final Metric<Integer> NEW_OVERALL_UNCOVERED_LINES = new Metric.Builder("new_overall_uncovered_lines", "Overall Uncovered Lines on New Code", Metric.ValueType.INT).setDescription("New lines that are not covered by any tests").setDirection(-1).setDomain(DOMAIN_COVERAGE).setBestValue(0.0).setDeleteHistoricalData(true).create();
    public static final String OVERALL_LINE_COVERAGE_KEY = "overall_line_coverage";
    public static final Metric<Double> OVERALL_LINE_COVERAGE = new Metric.Builder("overall_line_coverage", "Overall Line Coverage", Metric.ValueType.PERCENT).setDescription("Line coverage by all tests").setDirection(1).setQualitative(true).setDomain(DOMAIN_COVERAGE).create();
    public static final String NEW_OVERALL_LINE_COVERAGE_KEY = "new_overall_line_coverage";
    public static final Metric<Double> NEW_OVERALL_LINE_COVERAGE = new Metric.Builder("new_overall_line_coverage", "Overall Line Coverage on New Code", Metric.ValueType.PERCENT).setDescription("Line coverage of added/changed code by all tests").setDirection(1).setQualitative(true).setWorstValue(0.0).setBestValue(100.0).setDomain(DOMAIN_COVERAGE).setDeleteHistoricalData(true).create();
    @Deprecated
    public static final String OVERALL_COVERAGE_LINE_HITS_DATA_KEY = "overall_coverage_line_hits_data";
    @Deprecated
    public static final Metric<String> OVERALL_COVERAGE_LINE_HITS_DATA = new Metric.Builder("overall_coverage_line_hits_data", "Overall Coverage Hits by Line", Metric.ValueType.DATA).setDescription("Coverage hits by all tests and by line").setDirection(0).setQualitative(false).setDomain(DOMAIN_COVERAGE).setDeleteHistoricalData(true).create();
    public static final String OVERALL_CONDITIONS_TO_COVER_KEY = "overall_conditions_to_cover";
    public static final Metric<Integer> OVERALL_CONDITIONS_TO_COVER = new Metric.Builder("overall_conditions_to_cover", "Overall Branches to Cover", Metric.ValueType.INT).setDescription("Branches to cover by all tests").setDirection(1).setQualitative(false).setDomain(DOMAIN_COVERAGE).setHidden(true).create();
    public static final String NEW_OVERALL_CONDITIONS_TO_COVER_KEY = "new_overall_conditions_to_cover";
    public static final Metric<Integer> NEW_OVERALL_CONDITIONS_TO_COVER = new Metric.Builder("new_overall_conditions_to_cover", "Overall Branches to Cover on New Code", Metric.ValueType.INT).setDescription("New branches to cover by all tests").setDomain(DOMAIN_COVERAGE).setDeleteHistoricalData(true).setHidden(true).create();
    public static final String OVERALL_UNCOVERED_CONDITIONS_KEY = "overall_uncovered_conditions";
    public static final Metric<Integer> OVERALL_UNCOVERED_CONDITIONS = new Metric.Builder("overall_uncovered_conditions", "Overall Uncovered Conditions", Metric.ValueType.INT).setDescription("Uncovered conditions by all tests").setDirection(-1).setDomain(DOMAIN_COVERAGE).create();
    public static final String NEW_OVERALL_UNCOVERED_CONDITIONS_KEY = "new_overall_uncovered_conditions";
    public static final Metric<Integer> NEW_OVERALL_UNCOVERED_CONDITIONS = new Metric.Builder("new_overall_uncovered_conditions", "Overall Uncovered Conditions on New Code", Metric.ValueType.INT).setDescription("New conditions that are not covered by any test").setDirection(-1).setDomain(DOMAIN_COVERAGE).setBestValue(0.0).setDeleteHistoricalData(true).create();
    public static final String OVERALL_BRANCH_COVERAGE_KEY = "overall_branch_coverage";
    public static final Metric<Double> OVERALL_BRANCH_COVERAGE = new Metric.Builder("overall_branch_coverage", "Overall Condition Coverage", Metric.ValueType.PERCENT).setDescription("Condition coverage by all tests").setDirection(1).setQualitative(true).setDomain(DOMAIN_COVERAGE).setWorstValue(0.0).setBestValue(100.0).create();
    public static final String NEW_OVERALL_BRANCH_COVERAGE_KEY = "new_overall_branch_coverage";
    public static final Metric<Double> NEW_OVERALL_BRANCH_COVERAGE = new Metric.Builder("new_overall_branch_coverage", "Overall Condition Coverage on New Code", Metric.ValueType.PERCENT).setDescription("Condition coverage of new/changed code by all tests").setDirection(1).setQualitative(true).setDomain(DOMAIN_COVERAGE).setWorstValue(0.0).setBestValue(100.0).setDeleteHistoricalData(true).create();
    @Deprecated
    public static final String OVERALL_CONDITIONS_BY_LINE_KEY = "overall_conditions_by_line";
    @Deprecated
    public static final Metric<String> OVERALL_CONDITIONS_BY_LINE = new Metric.Builder("overall_conditions_by_line", "Overall Conditions by Line", Metric.ValueType.DATA).setDescription("Overall conditions by all tests and by line").setDomain(DOMAIN_COVERAGE).setDeleteHistoricalData(true).create();
    @Deprecated
    public static final String OVERALL_COVERED_CONDITIONS_BY_LINE_KEY = "overall_covered_conditions_by_line";
    @Deprecated
    public static final Metric<String> OVERALL_COVERED_CONDITIONS_BY_LINE = new Metric.Builder("overall_covered_conditions_by_line", "Overall Covered Conditions by Line", Metric.ValueType.DATA).setDescription("Overall covered conditions by all tests and by line").setDomain(DOMAIN_COVERAGE).setDeleteHistoricalData(true).create();
    public static final String DUPLICATED_LINES_KEY = "duplicated_lines";
    public static final Metric<Integer> DUPLICATED_LINES = new Metric.Builder("duplicated_lines", "Duplicated Lines", Metric.ValueType.INT).setDescription("Duplicated lines").setDirection(-1).setQualitative(true).setDomain(DOMAIN_DUPLICATIONS).setBestValue(0.0).setOptimizedBestValue(true).create();
    public static final String NEW_DUPLICATED_LINES_KEY = "new_duplicated_lines";
    public static final Metric<Integer> NEW_DUPLICATED_LINES = new Metric.Builder("new_duplicated_lines", "Duplicated Lines on New Code", Metric.ValueType.INT).setDescription("Duplicated Lines on New Code").setDirection(-1).setQualitative(true).setDomain(DOMAIN_DUPLICATIONS).setBestValue(0.0).setDeleteHistoricalData(true).create();
    public static final String DUPLICATED_BLOCKS_KEY = "duplicated_blocks";
    public static final Metric<Integer> DUPLICATED_BLOCKS = new Metric.Builder("duplicated_blocks", "Duplicated Blocks", Metric.ValueType.INT).setDescription("Duplicated blocks").setDirection(-1).setQualitative(true).setDomain(DOMAIN_DUPLICATIONS).setBestValue(0.0).setOptimizedBestValue(true).create();
    public static final String NEW_BLOCKS_DUPLICATED_KEY = "new_duplicated_blocks";
    public static final Metric<Integer> NEW_BLOCKS_DUPLICATED = new Metric.Builder("new_duplicated_blocks", "Duplicated Blocks on New Code", Metric.ValueType.INT).setDescription("Duplicated blocks on new code").setDirection(-1).setQualitative(true).setDomain(DOMAIN_DUPLICATIONS).setBestValue(0.0).setDeleteHistoricalData(true).create();
    public static final String DUPLICATED_FILES_KEY = "duplicated_files";
    public static final Metric<Integer> DUPLICATED_FILES = new Metric.Builder("duplicated_files", "Duplicated Files", Metric.ValueType.INT).setDescription("Duplicated files").setDirection(-1).setQualitative(true).setDomain(DOMAIN_DUPLICATIONS).setBestValue(0.0).setOptimizedBestValue(true).create();
    public static final String DUPLICATED_LINES_DENSITY_KEY = "duplicated_lines_density";
    public static final Metric<Double> DUPLICATED_LINES_DENSITY = new Metric.Builder("duplicated_lines_density", "Duplicated Lines (%)", Metric.ValueType.PERCENT).setDescription("Duplicated lines balanced by statements").setDirection(-1).setQualitative(true).setDomain(DOMAIN_DUPLICATIONS).setWorstValue(50.0).setBestValue(0.0).setOptimizedBestValue(true).create();
    public static final String NEW_DUPLICATED_LINES_DENSITY_KEY = "new_duplicated_lines_density";
    public static final Metric<Integer> NEW_DUPLICATED_LINES_DENSITY = new Metric.Builder("new_duplicated_lines_density", "Duplicated Lines on New Code (%)", Metric.ValueType.PERCENT).setDescription("Duplicated lines on new code balanced by statements").setDirection(-1).setQualitative(true).setDomain(DOMAIN_DUPLICATIONS).setBestValue(0.0).setDeleteHistoricalData(true).create();
    @Deprecated
    public static final String DUPLICATIONS_DATA_KEY = "duplications_data";
    @Deprecated
    public static final Metric<String> DUPLICATIONS_DATA = new Metric.Builder("duplications_data", "Duplication Details", Metric.ValueType.DATA).setDescription("Duplications details").setDirection(0).setQualitative(false).setDomain(DOMAIN_DUPLICATIONS).setDeleteHistoricalData(true).create();
    public static final String VIOLATIONS_KEY = "violations";
    public static final Metric<Integer> VIOLATIONS = new Metric.Builder("violations", "Issues", Metric.ValueType.INT).setDescription("Issues").setDirection(-1).setQualitative(true).setDomain(DOMAIN_ISSUES).setBestValue(0.0).setOptimizedBestValue(true).create();
    public static final String BLOCKER_VIOLATIONS_KEY = "blocker_violations";
    public static final Metric<Integer> BLOCKER_VIOLATIONS = new Metric.Builder("blocker_violations", "Blocker Issues", Metric.ValueType.INT).setDescription("Blocker issues").setDirection(-1).setQualitative(true).setDomain(DOMAIN_ISSUES).setBestValue(0.0).setOptimizedBestValue(true).create();
    public static final String CRITICAL_VIOLATIONS_KEY = "critical_violations";
    public static final Metric<Integer> CRITICAL_VIOLATIONS = new Metric.Builder("critical_violations", "Critical Issues", Metric.ValueType.INT).setDescription("Critical issues").setDirection(-1).setQualitative(true).setDomain(DOMAIN_ISSUES).setBestValue(0.0).setOptimizedBestValue(true).create();
    public static final String MAJOR_VIOLATIONS_KEY = "major_violations";
    public static final Metric<Integer> MAJOR_VIOLATIONS = new Metric.Builder("major_violations", "Major Issues", Metric.ValueType.INT).setDescription("Major issues").setDirection(-1).setQualitative(true).setDomain(DOMAIN_ISSUES).setBestValue(0.0).setOptimizedBestValue(true).create();
    public static final String MINOR_VIOLATIONS_KEY = "minor_violations";
    public static final Metric<Integer> MINOR_VIOLATIONS = new Metric.Builder("minor_violations", "Minor Issues", Metric.ValueType.INT).setDescription("Minor issues").setDirection(-1).setQualitative(true).setDomain(DOMAIN_ISSUES).setBestValue(0.0).setOptimizedBestValue(true).create();
    public static final String INFO_VIOLATIONS_KEY = "info_violations";
    public static final Metric<Integer> INFO_VIOLATIONS = new Metric.Builder("info_violations", "Info Issues", Metric.ValueType.INT).setDescription("Info issues").setDirection(-1).setQualitative(true).setDomain(DOMAIN_ISSUES).setBestValue(0.0).setOptimizedBestValue(true).create();
    public static final String NEW_VIOLATIONS_KEY = "new_violations";
    public static final Metric<Integer> NEW_VIOLATIONS = new Metric.Builder("new_violations", "New Issues", Metric.ValueType.INT).setDescription("New issues").setDirection(-1).setQualitative(true).setDomain(DOMAIN_ISSUES).setBestValue(0.0).setOptimizedBestValue(true).setDeleteHistoricalData(true).create();
    public static final String NEW_BLOCKER_VIOLATIONS_KEY = "new_blocker_violations";
    public static final Metric<Integer> NEW_BLOCKER_VIOLATIONS = new Metric.Builder("new_blocker_violations", "New Blocker Issues", Metric.ValueType.INT).setDescription("New Blocker issues").setDirection(-1).setQualitative(true).setDomain(DOMAIN_ISSUES).setBestValue(0.0).setOptimizedBestValue(true).setDeleteHistoricalData(true).create();
    public static final String NEW_CRITICAL_VIOLATIONS_KEY = "new_critical_violations";
    public static final Metric<Integer> NEW_CRITICAL_VIOLATIONS = new Metric.Builder("new_critical_violations", "New Critical Issues", Metric.ValueType.INT).setDescription("New Critical issues").setDirection(-1).setQualitative(true).setDomain(DOMAIN_ISSUES).setBestValue(0.0).setOptimizedBestValue(true).setDeleteHistoricalData(true).create();
    public static final String NEW_MAJOR_VIOLATIONS_KEY = "new_major_violations";
    public static final Metric<Integer> NEW_MAJOR_VIOLATIONS = new Metric.Builder("new_major_violations", "New Major Issues", Metric.ValueType.INT).setDescription("New Major issues").setDirection(-1).setQualitative(true).setDomain(DOMAIN_ISSUES).setBestValue(0.0).setOptimizedBestValue(true).setDeleteHistoricalData(true).create();
    public static final String NEW_MINOR_VIOLATIONS_KEY = "new_minor_violations";
    public static final Metric<Integer> NEW_MINOR_VIOLATIONS = new Metric.Builder("new_minor_violations", "New Minor Issues", Metric.ValueType.INT).setDescription("New Minor issues").setDirection(-1).setQualitative(true).setDomain(DOMAIN_ISSUES).setBestValue(0.0).setOptimizedBestValue(true).setDeleteHistoricalData(true).create();
    public static final String NEW_INFO_VIOLATIONS_KEY = "new_info_violations";
    public static final Metric<Integer> NEW_INFO_VIOLATIONS = new Metric.Builder("new_info_violations", "New Info Issues", Metric.ValueType.INT).setDescription("New Info issues").setDirection(-1).setQualitative(true).setDomain(DOMAIN_ISSUES).setBestValue(0.0).setOptimizedBestValue(true).setDeleteHistoricalData(true).create();
    public static final String FALSE_POSITIVE_ISSUES_KEY = "false_positive_issues";
    public static final Metric<Integer> FALSE_POSITIVE_ISSUES = new Metric.Builder("false_positive_issues", "False Positive Issues", Metric.ValueType.INT).setDescription("False positive issues").setDirection(-1).setDomain(DOMAIN_ISSUES).setBestValue(0.0).setOptimizedBestValue(true).create();
    public static final String WONT_FIX_ISSUES_KEY = "wont_fix_issues";
    public static final Metric<Integer> WONT_FIX_ISSUES = new Metric.Builder("wont_fix_issues", "Won't Fix Issues", Metric.ValueType.INT).setDescription("Won't fix issues").setDirection(-1).setDomain(DOMAIN_ISSUES).setBestValue(0.0).setOptimizedBestValue(true).create();
    public static final String OPEN_ISSUES_KEY = "open_issues";
    public static final Metric<Integer> OPEN_ISSUES = new Metric.Builder("open_issues", "Open Issues", Metric.ValueType.INT).setDescription("Open issues").setDirection(-1).setDomain(DOMAIN_ISSUES).setBestValue(0.0).setOptimizedBestValue(true).create();
    public static final String REOPENED_ISSUES_KEY = "reopened_issues";
    public static final Metric<Integer> REOPENED_ISSUES = new Metric.Builder("reopened_issues", "Reopened Issues", Metric.ValueType.INT).setDescription("Reopened issues").setDirection(-1).setQualitative(true).setDomain(DOMAIN_ISSUES).setBestValue(0.0).setOptimizedBestValue(true).create();
    public static final String CONFIRMED_ISSUES_KEY = "confirmed_issues";
    public static final Metric<Integer> CONFIRMED_ISSUES = new Metric.Builder("confirmed_issues", "Confirmed Issues", Metric.ValueType.INT).setDescription("Confirmed issues").setDirection(-1).setQualitative(true).setDomain(DOMAIN_ISSUES).setBestValue(0.0).setOptimizedBestValue(true).create();
    public static final String CODE_SMELLS_KEY = "code_smells";
    public static final Metric<Integer> CODE_SMELLS = new Metric.Builder("code_smells", "Code Smells", Metric.ValueType.INT).setDescription("Code Smells").setDirection(-1).setQualitative(false).setDomain(DOMAIN_MAINTAINABILITY).setBestValue(0.0).setOptimizedBestValue(true).create();
    public static final String NEW_CODE_SMELLS_KEY = "new_code_smells";
    public static final Metric<Integer> NEW_CODE_SMELLS = new Metric.Builder("new_code_smells", "New Code Smells", Metric.ValueType.INT).setDescription("New Code Smells").setDirection(-1).setQualitative(true).setDomain(DOMAIN_MAINTAINABILITY).setBestValue(0.0).setOptimizedBestValue(true).setDeleteHistoricalData(true).create();
    public static final String BUGS_KEY = "bugs";
    public static final Metric<Integer> BUGS = new Metric.Builder("bugs", "Bugs", Metric.ValueType.INT).setDescription("Bugs").setDirection(-1).setQualitative(false).setDomain(DOMAIN_RELIABILITY).setBestValue(0.0).setOptimizedBestValue(true).create();
    public static final String NEW_BUGS_KEY = "new_bugs";
    public static final Metric<Integer> NEW_BUGS = new Metric.Builder("new_bugs", "New Bugs", Metric.ValueType.INT).setDescription("New Bugs").setDirection(-1).setQualitative(true).setDomain(DOMAIN_RELIABILITY).setBestValue(0.0).setOptimizedBestValue(true).setDeleteHistoricalData(true).create();
    public static final String VULNERABILITIES_KEY = "vulnerabilities";
    public static final Metric<Integer> VULNERABILITIES = new Metric.Builder("vulnerabilities", "Vulnerabilities", Metric.ValueType.INT).setDescription("Vulnerabilities").setDirection(-1).setQualitative(false).setDomain(DOMAIN_SECURITY).setBestValue(0.0).setOptimizedBestValue(true).create();
    public static final String NEW_VULNERABILITIES_KEY = "new_vulnerabilities";
    public static final Metric<Integer> NEW_VULNERABILITIES = new Metric.Builder("new_vulnerabilities", "New Vulnerabilities", Metric.ValueType.INT).setDescription("New Vulnerabilities").setDirection(-1).setQualitative(true).setDomain(DOMAIN_SECURITY).setBestValue(0.0).setOptimizedBestValue(true).setDeleteHistoricalData(true).create();
    @Deprecated
    public static final String DEPENDENCY_MATRIX_KEY = "dsm";
    @Deprecated
    public static final transient Metric<String> DEPENDENCY_MATRIX = new Metric.Builder("dsm", "Dependency Matrix", Metric.ValueType.DATA).setDescription("Dependency Matrix").setDirection(0).setQualitative(false).setDomain(DOMAIN_DESIGN).setDeleteHistoricalData(true).create();
    @Deprecated
    public static final String DIRECTORY_CYCLES_KEY = "package_cycles";
    @Deprecated
    public static final transient Metric<Integer> DIRECTORY_CYCLES = new Metric.Builder("package_cycles", "Directory Cycles", Metric.ValueType.INT).setDescription("Directory cycles").setDirection(-1).setQualitative(true).setDomain(DOMAIN_DESIGN).setBestValue(0.0).create();
    @Deprecated
    public static final String PACKAGE_CYCLES_KEY = "package_cycles";
    @Deprecated
    public static final transient Metric<Integer> PACKAGE_CYCLES = DIRECTORY_CYCLES;
    @Deprecated
    public static final String DIRECTORY_TANGLE_INDEX_KEY = "package_tangle_index";
    @Deprecated
    public static final transient Metric<Double> DIRECTORY_TANGLE_INDEX = new Metric.Builder("package_tangle_index", "Directory Tangle Index", Metric.ValueType.PERCENT).setDescription("Directory tangle index").setDirection(-1).setQualitative(true).setBestValue(0.0).setDomain(DOMAIN_DESIGN).create();
    @Deprecated
    public static final String PACKAGE_TANGLE_INDEX_KEY = "package_tangle_index";
    @Deprecated
    public static final transient Metric<Double> PACKAGE_TANGLE_INDEX = DIRECTORY_TANGLE_INDEX;
    @Deprecated
    public static final String DIRECTORY_TANGLES_KEY = "package_tangles";
    @Deprecated
    public static final transient Metric<Integer> DIRECTORY_TANGLES = new Metric.Builder("package_tangles", "File Dependencies to Cut", Metric.ValueType.INT).setDescription("File dependencies to cut").setDirection(-1).setQualitative(false).setDomain(DOMAIN_DESIGN).create();
    @Deprecated
    public static final String PACKAGE_TANGLES_KEY = "package_tangles";
    @Deprecated
    public static final transient Metric<Integer> PACKAGE_TANGLES = DIRECTORY_TANGLES;
    @Deprecated
    public static final String DIRECTORY_FEEDBACK_EDGES_KEY = "package_feedback_edges";
    @Deprecated
    public static final transient Metric<Integer> DIRECTORY_FEEDBACK_EDGES = new Metric.Builder("package_feedback_edges", "Package Dependencies to Cut", Metric.ValueType.INT).setDescription("Package dependencies to cut").setDirection(-1).setQualitative(false).setDomain(DOMAIN_DESIGN).setBestValue(0.0).create();
    @Deprecated
    public static final String PACKAGE_FEEDBACK_EDGES_KEY = "package_feedback_edges";
    @Deprecated
    public static final transient Metric<Integer> PACKAGE_FEEDBACK_EDGES = DIRECTORY_FEEDBACK_EDGES;
    @Deprecated
    public static final String DIRECTORY_EDGES_WEIGHT_KEY = "package_edges_weight";
    @Deprecated
    public static final transient Metric<Integer> DIRECTORY_EDGES_WEIGHT = new Metric.Builder("package_edges_weight", "Directory Edges Weight", Metric.ValueType.INT).setDescription("Directory edges weight").setDirection(1).setQualitative(false).setDomain(DOMAIN_DESIGN).setHidden(true).setDeleteHistoricalData(true).create();
    @Deprecated
    public static final String PACKAGE_EDGES_WEIGHT_KEY = "package_edges_weight";
    @Deprecated
    public static final transient Metric<Integer> PACKAGE_EDGES_WEIGHT = DIRECTORY_EDGES_WEIGHT;
    @Deprecated
    public static final String FILE_CYCLES_KEY = "file_cycles";
    @Deprecated
    public static final transient Metric<Integer> FILE_CYCLES = new Metric.Builder("file_cycles", "File Cycles", Metric.ValueType.INT).setDescription("File cycles").setDirection(-1).setQualitative(true).setDomain(DOMAIN_DESIGN).setHidden(true).setDeleteHistoricalData(true).setBestValue(0.0).create();
    @Deprecated
    public static final String FILE_TANGLE_INDEX_KEY = "file_tangle_index";
    @Deprecated
    public static final transient Metric<Double> FILE_TANGLE_INDEX = new Metric.Builder("file_tangle_index", "File Tangle Index", Metric.ValueType.PERCENT).setDescription("File tangle index").setDirection(-1).setQualitative(true).setDomain(DOMAIN_DESIGN).setHidden(true).setDeleteHistoricalData(true).setBestValue(0.0).create();
    @Deprecated
    public static final String FILE_TANGLES_KEY = "file_tangles";
    @Deprecated
    public static final transient Metric<Integer> FILE_TANGLES = new Metric.Builder("file_tangles", "File Tangles", Metric.ValueType.INT).setDescription("Files tangles").setDirection(-1).setQualitative(false).setDomain(DOMAIN_DESIGN).setHidden(true).setDeleteHistoricalData(true).create();
    @Deprecated
    public static final String FILE_FEEDBACK_EDGES_KEY = "file_feedback_edges";
    @Deprecated
    public static final transient Metric<Integer> FILE_FEEDBACK_EDGES = new Metric.Builder("file_feedback_edges", "Suspect File Dependencies", Metric.ValueType.INT).setDescription("Suspect file dependencies").setDirection(-1).setQualitative(false).setDomain(DOMAIN_DESIGN).setHidden(true).setDeleteHistoricalData(true).setBestValue(0.0).create();
    @Deprecated
    public static final String FILE_EDGES_WEIGHT_KEY = "file_edges_weight";
    @Deprecated
    public static final transient Metric<Integer> FILE_EDGES_WEIGHT = new Metric.Builder("file_edges_weight", "File Edges Weight", Metric.ValueType.INT).setDescription("File edges weight").setDirection(1).setQualitative(false).setDomain(DOMAIN_DESIGN).setHidden(true).setDeleteHistoricalData(true).create();
    @Deprecated
    public static final String SCM_AUTHORS_BY_LINE_KEY = "authors_by_line";
    @Deprecated
    public static final transient Metric<String> SCM_AUTHORS_BY_LINE = new Metric.Builder("authors_by_line", "Authors by Line", Metric.ValueType.DATA).setDomain(DOMAIN_SCM).create();
    @Deprecated
    public static final String SCM_REVISIONS_BY_LINE_KEY = "revisions_by_line";
    @Deprecated
    public static final transient Metric<String> SCM_REVISIONS_BY_LINE = new Metric.Builder("revisions_by_line", "Revisions by Line", Metric.ValueType.DATA).setDomain(DOMAIN_SCM).create();
    @Deprecated
    public static final String SCM_LAST_COMMIT_DATETIMES_BY_LINE_KEY = "last_commit_datetimes_by_line";
    @Deprecated
    public static final transient Metric<String> SCM_LAST_COMMIT_DATETIMES_BY_LINE = new Metric.Builder("last_commit_datetimes_by_line", "Last Commit Dates by Line", Metric.ValueType.DATA).setDomain(DOMAIN_SCM).create();
    public static final String TECHNICAL_DEBT_KEY = "sqale_index";
    public static final Metric<Long> TECHNICAL_DEBT = new Metric.Builder("sqale_index", "Technical Debt", Metric.ValueType.WORK_DUR).setDescription("Total effort (in days) to fix all the issues on the component and therefore to comply to all the requirements.").setDomain(DOMAIN_MAINTAINABILITY).setDirection(-1).setOptimizedBestValue(true).setBestValue(0.0).setQualitative(true).create();
    public static final String NEW_TECHNICAL_DEBT_KEY = "new_technical_debt";
    public static final Metric<Long> NEW_TECHNICAL_DEBT = new Metric.Builder("new_technical_debt", "Added Technical Debt", Metric.ValueType.WORK_DUR).setDescription("Added technical debt").setDomain(DOMAIN_MAINTAINABILITY).setDirection(-1).setOptimizedBestValue(true).setBestValue(0.0).setQualitative(true).setDeleteHistoricalData(true).create();
    public static final String SQALE_RATING_KEY = "sqale_rating";
    public static final Metric<Integer> SQALE_RATING = new Metric.Builder("sqale_rating", "Maintainability Rating", Metric.ValueType.RATING).setDescription("A-to-E rating based on the technical debt ratio").setDomain(DOMAIN_MAINTAINABILITY).setDirection(-1).setQualitative(true).setBestValue(1.0).setWorstValue(5.0).create();
    public static final String DEVELOPMENT_COST_KEY = "development_cost";
    public static final Metric<String> DEVELOPMENT_COST = new Metric.Builder("development_cost", "SQALE Development Cost", Metric.ValueType.STRING).setDescription("SQALE development cost").setDomain(DOMAIN_MAINTAINABILITY).setDirection(-1).setOptimizedBestValue(true).setBestValue(0.0).setQualitative(true).setHidden(true).create();
    public static final String SQALE_DEBT_RATIO_KEY = "sqale_debt_ratio";
    public static final Metric<Double> SQALE_DEBT_RATIO = new Metric.Builder("sqale_debt_ratio", "Technical Debt Ratio", Metric.ValueType.PERCENT).setDescription("Ratio of the actual technical debt compared to the estimated cost to develop the whole source code from scratch").setDomain(DOMAIN_MAINTAINABILITY).setDirection(-1).setOptimizedBestValue(true).setBestValue(0.0).setQualitative(true).create();
    public static final String NEW_SQALE_DEBT_RATIO_KEY = "new_sqale_debt_ratio";
    public static final Metric<Double> NEW_SQALE_DEBT_RATIO = new Metric.Builder("new_sqale_debt_ratio", "Technical Debt Ratio on New Code", Metric.ValueType.PERCENT).setDescription("Technical Debt Ratio of new/changed code.").setDomain(DOMAIN_MAINTAINABILITY).setDirection(-1).setOptimizedBestValue(true).setBestValue(0.0).setQualitative(true).create();
    public static final String EFFORT_TO_REACH_MAINTAINABILITY_RATING_A_KEY = "effort_to_reach_maintainability_rating_a";
    public static final Metric<Long> EFFORT_TO_REACH_MAINTAINABILITY_RATING_A = new Metric.Builder("effort_to_reach_maintainability_rating_a", "Effort to Reach Maintainability Rating A", Metric.ValueType.WORK_DUR).setDescription("Effort to reach maintainability rating A").setDomain(DOMAIN_MAINTAINABILITY).setDirection(-1).setQualitative(true).setBestValue(0.0).setOptimizedBestValue(true).create();
    public static final String RELIABILITY_REMEDIATION_EFFORT_KEY = "reliability_remediation_effort";
    public static final Metric<Long> RELIABILITY_REMEDIATION_EFFORT = new Metric.Builder("reliability_remediation_effort", "Reliability Remediation Effort", Metric.ValueType.WORK_DUR).setDescription("Reliability Remediation Effort").setDomain(DOMAIN_RELIABILITY).setDirection(-1).setOptimizedBestValue(true).setBestValue(0.0).setQualitative(true).create();
    public static final String NEW_RELIABILITY_REMEDIATION_EFFORT_KEY = "new_reliability_remediation_effort";
    public static final Metric<Long> NEW_RELIABILITY_REMEDIATION_EFFORT = new Metric.Builder("new_reliability_remediation_effort", "Reliability Remediation Effort on New Code", Metric.ValueType.WORK_DUR).setDescription("Reliability remediation effort on new code").setDomain(DOMAIN_RELIABILITY).setDirection(-1).setOptimizedBestValue(true).setBestValue(0.0).setQualitative(true).setDeleteHistoricalData(true).create();
    public static final String RELIABILITY_RATING_KEY = "reliability_rating";
    public static final Metric<Integer> RELIABILITY_RATING = new Metric.Builder("reliability_rating", "Reliability Rating", Metric.ValueType.RATING).setDescription("Reliability rating").setDomain(DOMAIN_RELIABILITY).setDirection(-1).setQualitative(true).setBestValue(1.0).setWorstValue(5.0).create();
    public static final String SECURITY_REMEDIATION_EFFORT_KEY = "security_remediation_effort";
    public static final Metric<Long> SECURITY_REMEDIATION_EFFORT = new Metric.Builder("security_remediation_effort", "Security Remediation Effort", Metric.ValueType.WORK_DUR).setDescription("Security remediation effort").setDomain(DOMAIN_SECURITY).setDirection(-1).setOptimizedBestValue(true).setBestValue(0.0).setQualitative(true).create();
    public static final String NEW_SECURITY_REMEDIATION_EFFORT_KEY = "new_security_remediation_effort";
    public static final Metric<Long> NEW_SECURITY_REMEDIATION_EFFORT = new Metric.Builder("new_security_remediation_effort", "Security Remediation Effort on New Code", Metric.ValueType.WORK_DUR).setDescription("Security remediation effort on new code").setDomain(DOMAIN_SECURITY).setDirection(-1).setOptimizedBestValue(true).setBestValue(0.0).setQualitative(true).setDeleteHistoricalData(true).create();
    public static final String SECURITY_RATING_KEY = "security_rating";
    public static final Metric<Integer> SECURITY_RATING = new Metric.Builder("security_rating", "Security Rating", Metric.ValueType.RATING).setDescription("Security rating").setDomain(DOMAIN_SECURITY).setDirection(-1).setQualitative(true).setBestValue(1.0).setWorstValue(5.0).create();
    public static final String NCLOC_DATA_KEY = "ncloc_data";
    public static final Metric<String> NCLOC_DATA = new Metric.Builder("ncloc_data", "ncloc_data", Metric.ValueType.DATA).setHidden(true).setDomain(DOMAIN_SIZE).create();
    public static final String COMMENT_LINES_DATA_KEY = "comment_lines_data";
    public static final Metric<String> COMMENT_LINES_DATA = new Metric.Builder("comment_lines_data", "comment_lines_data", Metric.ValueType.DATA).setHidden(true).setDomain(DOMAIN_DOCUMENTATION).create();
    public static final String EXECUTABLE_LINES_DATA_KEY = "executable_lines_data";
    public static final Metric<String> EXECUTABLE_LINES_DATA = new Metric.Builder("executable_lines_data", "executable_lines_data", Metric.ValueType.DATA).setHidden(true).setDomain(DOMAIN_COVERAGE).create();
    public static final String ALERT_STATUS_KEY = "alert_status";
    public static final Metric<Metric.Level> ALERT_STATUS = new Metric.Builder("alert_status", "Quality Gate Status", Metric.ValueType.LEVEL).setDescription("The project status with regard to its quality gate.").setDirection(1).setQualitative(true).setDomain(DOMAIN_RELEASABILITY).create();
    public static final String QUALITY_GATE_DETAILS_KEY = "quality_gate_details";
    public static final Metric<String> QUALITY_GATE_DETAILS = new Metric.Builder("quality_gate_details", "Quality Gate Details", Metric.ValueType.DATA).setDescription("The project detailed status with regard to its quality gate").setDomain(DOMAIN_GENERAL).create();
    @Deprecated
    public static final String QUALITY_PROFILES_KEY = "quality_profiles";
    @Deprecated
    public static final Metric<String> QUALITY_PROFILES = new Metric.Builder("quality_profiles", "Profiles", Metric.ValueType.DATA).setDescription("Details of quality profiles used during analysis").setQualitative(false).setDomain(DOMAIN_GENERAL).setHidden(true).create();
    public static final String LAST_COMMIT_DATE_KEY = "last_commit_date";
    public static final Metric LAST_COMMIT_DATE = new Metric.Builder("last_commit_date", "Date of Last Commit", Metric.ValueType.MILLISEC).setDomain(DOMAIN_SCM).setHidden(true).create();
    private static final List<Metric> METRICS = new LinkedList<Metric>();

    private CoreMetrics() {
    }

    public static List<Metric> getMetrics() {
        return METRICS;
    }

    public static Metric getMetric(String key) {
        return METRICS.stream().filter(metric -> metric != null && metric.getKey().equals(key)).findFirst().orElseThrow(NoSuchElementException::new);
    }

    static {
        for (Field field : CoreMetrics.class.getFields()) {
            if (Modifier.isTransient(field.getModifiers()) || !Metric.class.isAssignableFrom(field.getType())) continue;
            try {
                Metric metric = (Metric)field.get(null);
                METRICS.add(metric);
            }
            catch (IllegalAccessException e) {
                throw new SonarException("can not introspect " + CoreMetrics.class + " to get metrics", e);
            }
        }
    }
}

