/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.debt;

import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.internal.apachecommons.lang.builder.EqualsBuilder;
import org.sonar.api.internal.apachecommons.lang.builder.HashCodeBuilder;
import org.sonar.api.internal.apachecommons.lang.builder.ReflectionToStringBuilder;
import org.sonar.api.internal.apachecommons.lang.builder.ToStringStyle;
import org.sonar.api.utils.Duration;

public class DebtRemediationFunction {
    private Type type;
    private Duration coefficient;
    private Duration offset;

    private DebtRemediationFunction(Type type, @Nullable Duration coefficient, @Nullable Duration offset) {
        this.type = type;
        this.coefficient = coefficient;
        this.offset = offset;
    }

    public static DebtRemediationFunction create(Type type, @Nullable Duration coefficient, @Nullable Duration offset) {
        return new DebtRemediationFunction(type, coefficient, offset);
    }

    public static DebtRemediationFunction createLinear(Duration coefficient) {
        return new DebtRemediationFunction(Type.LINEAR, coefficient, null);
    }

    public static DebtRemediationFunction createLinearWithOffset(Duration coefficient, Duration offset) {
        return new DebtRemediationFunction(Type.LINEAR_OFFSET, coefficient, offset);
    }

    public static DebtRemediationFunction createConstantPerIssue(Duration offset) {
        return new DebtRemediationFunction(Type.CONSTANT_ISSUE, null, offset);
    }

    public Type type() {
        return this.type;
    }

    @CheckForNull
    public Duration coefficient() {
        return this.coefficient;
    }

    @CheckForNull
    public Duration offset() {
        return this.offset;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DebtRemediationFunction that = (DebtRemediationFunction)o;
        return new EqualsBuilder().append((Object)this.type, (Object)that.type()).append(this.coefficient, that.coefficient()).append(this.offset, that.offset()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(15, 31).append((Object)this.type).append(this.coefficient).append(this.offset).toHashCode();
    }

    public String toString() {
        return new ReflectionToStringBuilder(this, ToStringStyle.SHORT_PREFIX_STYLE).toString();
    }

    public static enum Type {
        LINEAR,
        LINEAR_OFFSET,
        CONSTANT_ISSUE;

    }
}

