/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.fs.internal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.batch.fs.IndexedFile;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.internal.DefaultInputComponent;
import org.sonar.api.batch.fs.internal.TestInputFileBuilder;
import org.sonar.api.utils.PathUtils;

public class DefaultIndexedFile
extends DefaultInputComponent
implements IndexedFile {
    private final String relativePath;
    private final String moduleKey;
    private final Path moduleBaseDir;
    private String language;
    private final InputFile.Type type;

    public DefaultIndexedFile(String moduleKey, Path moduleBaseDir, String relativePath) {
        this(moduleKey, moduleBaseDir, relativePath, TestInputFileBuilder.nextBatchId());
    }

    public DefaultIndexedFile(String moduleKey, Path moduleBaseDir, String relativePath, int batchId) {
        this(moduleKey, moduleBaseDir, relativePath, InputFile.Type.MAIN, batchId);
    }

    public DefaultIndexedFile(String moduleKey, Path moduleBaseDir, String relativePath, InputFile.Type type, int batchId) {
        super(batchId);
        this.moduleKey = moduleKey;
        this.relativePath = PathUtils.sanitize(relativePath);
        this.moduleBaseDir = moduleBaseDir.normalize();
        this.type = type;
    }

    public DefaultIndexedFile setLanguage(@Nullable String language) {
        this.language = language;
        return this;
    }

    @Override
    public String relativePath() {
        return this.relativePath;
    }

    @Override
    public String absolutePath() {
        return PathUtils.sanitize(this.path().toString());
    }

    @Override
    public File file() {
        return this.path().toFile();
    }

    @Override
    public Path path() {
        return this.moduleBaseDir.resolve(this.relativePath);
    }

    @Override
    public InputStream inputStream() throws IOException {
        return Files.newInputStream(this.path(), new OpenOption[0]);
    }

    @Override
    @CheckForNull
    public String language() {
        return this.language;
    }

    @Override
    public InputFile.Type type() {
        return this.type;
    }

    @Override
    public String key() {
        return this.moduleKey + ":" + this.relativePath;
    }

    public String moduleKey() {
        return this.moduleKey;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultIndexedFile)) {
            return false;
        }
        DefaultIndexedFile that = (DefaultIndexedFile)o;
        return this.moduleKey.equals(that.moduleKey) && this.relativePath.equals(that.relativePath);
    }

    @Override
    public int hashCode() {
        return this.moduleKey.hashCode() + this.relativePath.hashCode() * 13;
    }

    @Override
    public String toString() {
        return "[moduleKey=" + this.moduleKey + ", relative=" + this.relativePath + ", basedir=" + this.moduleBaseDir + "]";
    }

    @Override
    public boolean isFile() {
        return true;
    }
}

