/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.issue.condition;

import org.sonar.api.internal.google.common.annotations.Beta;
import org.sonar.api.internal.google.common.base.Preconditions;
import org.sonar.api.internal.google.common.base.Strings;
import org.sonar.api.issue.Issue;
import org.sonar.api.issue.condition.Condition;

@Beta
public final class HasIssuePropertyCondition
implements Condition {
    private final String propertyKey;

    public HasIssuePropertyCondition(String propertyKey) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(propertyKey));
        this.propertyKey = propertyKey;
    }

    public String getPropertyKey() {
        return this.propertyKey;
    }

    @Override
    public boolean matches(Issue issue) {
        return !Strings.isNullOrEmpty(issue.attribute(this.propertyKey));
    }
}

