/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.sonar.api.SonarRuntime;
import org.sonar.api.utils.Version;

public interface Plugin {
    public void define(Context var1);

    public static class Context {
        private final SonarRuntime sonarRuntime;
        private final List extensions = new ArrayList();

        public Context(SonarRuntime sonarRuntime) {
            this.sonarRuntime = sonarRuntime;
        }

        public Version getSonarQubeVersion() {
            return this.sonarRuntime.getApiVersion();
        }

        public SonarRuntime getRuntime() {
            return this.sonarRuntime;
        }

        public Context addExtension(Object extension) {
            Objects.requireNonNull(extension);
            this.extensions.add(extension);
            return this;
        }

        public Context addExtensions(Collection extensions) {
            this.extensions.addAll(extensions);
            return this;
        }

        public Context addExtensions(Object first, Object second, Object ... others) {
            this.addExtension(first);
            this.addExtension(second);
            this.addExtensions(Arrays.asList(others));
            return this;
        }

        public List getExtensions() {
            return this.extensions;
        }
    }
}

