/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.fs.internal;

import javax.annotation.concurrent.ThreadSafe;
import org.sonar.api.internal.apachecommons.io.FilenameUtils;
import org.sonar.api.internal.apachecommons.lang.StringUtils;
import org.sonar.api.utils.WildcardPattern;

@ThreadSafe
public abstract class PathPattern {
    final WildcardPattern pattern;

    PathPattern(String pattern) {
        this.pattern = WildcardPattern.create(pattern);
    }

    public abstract boolean match(String var1, String var2);

    public abstract boolean match(String var1, String var2, boolean var3);

    public static PathPattern create(String s) {
        String trimmed = StringUtils.trim(s);
        if (StringUtils.startsWithIgnoreCase(trimmed, "file:")) {
            return new AbsolutePathPattern(StringUtils.substring(trimmed, "file:".length()));
        }
        return new RelativePathPattern(trimmed);
    }

    public static PathPattern[] create(String[] s) {
        PathPattern[] result = new PathPattern[s.length];
        for (int i = 0; i < s.length; ++i) {
            result[i] = PathPattern.create(s[i]);
        }
        return result;
    }

    static String sanitizeExtension(String suffix) {
        return StringUtils.lowerCase(StringUtils.removeStart(suffix, "."));
    }

    private static class RelativePathPattern
    extends PathPattern {
        private RelativePathPattern(String pattern) {
            super(pattern);
        }

        @Override
        public boolean match(String absolutePath, String relativePath) {
            return this.match(absolutePath, relativePath, true);
        }

        @Override
        public boolean match(String absolutePath, String relativePath, boolean caseSensitiveFileExtension) {
            String extension;
            String path = relativePath;
            if (!caseSensitiveFileExtension && StringUtils.isNotBlank(extension = RelativePathPattern.sanitizeExtension(FilenameUtils.getExtension(relativePath)))) {
                path = StringUtils.removeEndIgnoreCase(path, extension);
                path = path + extension;
            }
            return path != null && this.pattern.match(path);
        }

        public String toString() {
            return this.pattern.toString();
        }
    }

    private static class AbsolutePathPattern
    extends PathPattern {
        private AbsolutePathPattern(String pattern) {
            super(pattern);
        }

        @Override
        public boolean match(String absolutePath, String relativePath) {
            return this.match(absolutePath, relativePath, true);
        }

        @Override
        public boolean match(String absolutePath, String relativePath, boolean caseSensitiveFileExtension) {
            String extension;
            String path = absolutePath;
            if (!caseSensitiveFileExtension && StringUtils.isNotBlank(extension = AbsolutePathPattern.sanitizeExtension(FilenameUtils.getExtension(relativePath)))) {
                path = StringUtils.removeEndIgnoreCase(path, extension);
                path = path + extension;
            }
            return this.pattern.match(path);
        }

        public String toString() {
            return "file:" + this.pattern.toString();
        }
    }
}

