/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.config;

import java.io.IOException;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.sonar.api.internal.apachecommons.codec.binary.Base64;
import org.sonar.api.internal.apachecommons.io.IOUtils;
import org.sonar.api.internal.apachecommons.lang.StringUtils;
import org.sonar.api.internal.google.common.annotations.VisibleForTesting;
import org.sonar.api.utils.DateUtils;

public final class License {
    private String product;
    private String organization;
    private String expirationDate;
    private String type;
    private String server;
    private Map<String, String> additionalProperties;

    private License(Map<String, String> properties) {
        this.additionalProperties = new HashMap<String, String>(properties);
        this.product = StringUtils.defaultString(this.get("Product", properties), this.get("Plugin", properties));
        this.organization = StringUtils.defaultString(this.get("Organisation", properties), this.get("Name", properties));
        this.expirationDate = StringUtils.defaultString(this.get("Expiration", properties), this.get("Expires", properties));
        this.type = this.get("Type", properties);
        this.server = this.get("Server", properties);
        this.additionalProperties.remove("Digest");
        this.additionalProperties.remove("Obeo");
    }

    private String get(String key, Map<String, String> properties) {
        this.additionalProperties.remove(key);
        return properties.get(key);
    }

    public Map<String, String> additionalProperties() {
        return this.additionalProperties;
    }

    @Nullable
    public String getProduct() {
        return this.product;
    }

    @Nullable
    public String getOrganization() {
        return this.organization;
    }

    @Nullable
    public String getExpirationDateAsString() {
        return this.expirationDate;
    }

    @Nullable
    public Date getExpirationDate() {
        return DateUtils.parseDateQuietly(this.expirationDate);
    }

    public boolean isExpired() {
        return this.isExpired(new Date());
    }

    @VisibleForTesting
    boolean isExpired(Date now) {
        Date date = this.getExpirationDate();
        if (date == null) {
            return false;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(5, 1);
        cal.add(13, -1);
        return now.after(cal.getTime());
    }

    @Nullable
    public String getType() {
        return this.type;
    }

    @Nullable
    public String getServer() {
        return this.server;
    }

    public static License readBase64(String base64) {
        return License.readPlainText(new String(Base64.decodeBase64(base64.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8));
    }

    @VisibleForTesting
    static License readPlainText(String data) {
        HashMap<String, String> props = new HashMap<String, String>();
        try {
            List<String> lines = IOUtils.readLines(new StringReader(data));
            for (String line : lines) {
                if (!StringUtils.isNotBlank(line) || line.indexOf(58) <= 0) continue;
                String key = StringUtils.substringBefore(line, ":");
                String value = StringUtils.substringAfter(line, ":");
                props.put(StringUtils.trimToEmpty(key), StringUtils.trimToEmpty(value));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new License(props);
    }
}

