/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.server.ws.internal;

import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.internal.apachecommons.io.IOUtils;
import org.sonar.api.internal.google.common.base.Splitter;
import org.sonar.api.server.ws.LocalConnector;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.internal.PartImpl;

public class SimpleGetRequest
extends Request {
    private final Map<String, String> params = new HashMap<String, String>();
    private final Map<String, Request.Part> parts = new HashMap<String, Request.Part>();
    private String mediaType = "application/json";
    private String path;

    @Override
    public String method() {
        return "GET";
    }

    @Override
    public String getMediaType() {
        return this.mediaType;
    }

    public SimpleGetRequest setMediaType(String mediaType) {
        Objects.requireNonNull(mediaType);
        this.mediaType = mediaType;
        return this;
    }

    @Override
    public boolean hasParam(String key) {
        return this.params.keySet().contains(key);
    }

    @Override
    public String param(String key) {
        return this.params.get(key);
    }

    @Override
    public List<String> multiParam(String key) {
        String value = this.params.get(key);
        return value == null ? Collections.emptyList() : Collections.singletonList(value);
    }

    @Override
    @CheckForNull
    public List<String> paramAsStrings(String key) {
        String value = this.param(key);
        if (value == null) {
            return null;
        }
        return Splitter.on(',').omitEmptyStrings().trimResults().splitToList(value);
    }

    @Override
    public InputStream paramAsInputStream(String key) {
        return IOUtils.toInputStream(this.param(key), StandardCharsets.UTF_8);
    }

    public SimpleGetRequest setParam(String key, @Nullable String value) {
        if (value != null) {
            this.params.put(key, value);
        }
        return this;
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    @Override
    public Request.Part paramAsPart(String key) {
        return this.parts.get(key);
    }

    public SimpleGetRequest setPart(String key, InputStream input, String fileName) {
        this.parts.put(key, new PartImpl(input, fileName));
        return this;
    }

    @Override
    public LocalConnector localConnector() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getPath() {
        return this.path;
    }

    public SimpleGetRequest setPath(String path) {
        this.path = path;
        return this;
    }
}

