/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.utils;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.sonar.api.batch.ScannerSide;
import org.sonar.api.ce.ComputeEngineSide;
import org.sonar.api.internal.google.common.annotations.VisibleForTesting;
import org.sonar.api.internal.google.common.base.Preconditions;
import org.sonar.api.internal.google.common.base.Throwables;
import org.sonar.api.internal.google.common.collect.Lists;
import org.sonar.api.internal.google.common.io.Files;
import org.sonar.api.server.ServerSide;

@ScannerSide
@ServerSide
@ComputeEngineSide
public class UriReader {
    private final Map<String, SchemeProcessor> processorsByScheme = new HashMap<String, SchemeProcessor>();

    public UriReader(SchemeProcessor[] processors) {
        List<SchemeProcessor> allProcessors = Lists.asList(new FileProcessor(), processors);
        for (SchemeProcessor processor : allProcessors) {
            for (String scheme : processor.getSupportedSchemes()) {
                this.processorsByScheme.put(scheme.toLowerCase(Locale.ENGLISH), processor);
            }
        }
    }

    public byte[] readBytes(URI uri) {
        return this.searchForSupportedProcessor(uri).readBytes(uri);
    }

    public String readString(URI uri, Charset charset) {
        return this.searchForSupportedProcessor(uri).readString(uri, charset);
    }

    public String description(URI uri) {
        SchemeProcessor reader = this.searchForSupportedProcessor(uri);
        return reader.description(uri);
    }

    @VisibleForTesting
    SchemeProcessor searchForSupportedProcessor(URI uri) {
        SchemeProcessor processor = this.processorsByScheme.get(uri.getScheme().toLowerCase(Locale.ENGLISH));
        Preconditions.checkArgument(processor != null, "URI schema is not supported: " + uri.getScheme());
        return processor;
    }

    private static class FileProcessor
    extends SchemeProcessor {
        private FileProcessor() {
        }

        @Override
        public String[] getSupportedSchemes() {
            return new String[]{"file"};
        }

        @Override
        protected byte[] readBytes(URI uri) {
            try {
                return Files.toByteArray(new File(uri));
            }
            catch (IOException e) {
                throw Throwables.propagate(e);
            }
        }

        @Override
        protected String readString(URI uri, Charset charset) {
            try {
                return Files.toString(new File(uri), charset);
            }
            catch (IOException e) {
                throw Throwables.propagate(e);
            }
        }

        @Override
        protected String description(URI uri) {
            return new File(uri).getAbsolutePath();
        }
    }

    public static abstract class SchemeProcessor {
        protected abstract String[] getSupportedSchemes();

        protected abstract byte[] readBytes(URI var1);

        protected abstract String readString(URI var1, Charset var2);

        protected abstract String description(URI var1);
    }
}

