/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.sensor.issue.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.sonar.api.batch.rule.Severity;
import org.sonar.api.batch.sensor.internal.DefaultStorable;
import org.sonar.api.batch.sensor.internal.SensorStorage;
import org.sonar.api.batch.sensor.issue.Issue;
import org.sonar.api.batch.sensor.issue.IssueLocation;
import org.sonar.api.batch.sensor.issue.NewIssue;
import org.sonar.api.batch.sensor.issue.NewIssueLocation;
import org.sonar.api.batch.sensor.issue.internal.DefaultIssueLocation;
import org.sonar.api.internal.google.common.base.Preconditions;
import org.sonar.api.rule.RuleKey;

public class DefaultIssue
extends DefaultStorable
implements Issue,
NewIssue {
    private RuleKey ruleKey;
    private Double gap;
    private Severity overriddenSeverity;
    private IssueLocation primaryLocation;
    private List<List<IssueLocation>> flows = new ArrayList<List<IssueLocation>>();

    public DefaultIssue() {
        super(null);
    }

    public DefaultIssue(SensorStorage storage) {
        super(storage);
    }

    @Override
    public DefaultIssue forRule(RuleKey ruleKey) {
        this.ruleKey = ruleKey;
        return this;
    }

    @Override
    public DefaultIssue effortToFix(@Nullable Double effortToFix) {
        return this.gap(effortToFix);
    }

    @Override
    public DefaultIssue gap(@Nullable Double gap) {
        Preconditions.checkArgument(gap == null || gap >= 0.0, String.format("Gap must be greater than or equal 0 (got %s)", gap));
        this.gap = gap;
        return this;
    }

    @Override
    public DefaultIssue overrideSeverity(@Nullable Severity severity) {
        this.overriddenSeverity = severity;
        return this;
    }

    @Override
    public NewIssueLocation newLocation() {
        return new DefaultIssueLocation();
    }

    @Override
    public DefaultIssue at(NewIssueLocation primaryLocation) {
        Preconditions.checkArgument(primaryLocation != null, "Cannot use a location that is null");
        Preconditions.checkState(this.primaryLocation == null, "at() already called");
        this.primaryLocation = (DefaultIssueLocation)primaryLocation;
        Preconditions.checkArgument(this.primaryLocation.inputComponent() != null, "Cannot use a location with no input component");
        return this;
    }

    @Override
    public NewIssue addLocation(NewIssueLocation secondaryLocation) {
        this.flows.add(Arrays.asList((IssueLocation)((Object)secondaryLocation)));
        return this;
    }

    @Override
    public DefaultIssue addFlow(Iterable<NewIssueLocation> locations) {
        ArrayList<DefaultIssueLocation> flowAsList = new ArrayList<DefaultIssueLocation>();
        for (NewIssueLocation issueLocation : locations) {
            flowAsList.add((DefaultIssueLocation)issueLocation);
        }
        this.flows.add(flowAsList);
        return this;
    }

    @Override
    public RuleKey ruleKey() {
        return this.ruleKey;
    }

    @Override
    public Severity overriddenSeverity() {
        return this.overriddenSeverity;
    }

    @Override
    public Double gap() {
        return this.gap;
    }

    @Override
    public Double effortToFix() {
        return this.gap;
    }

    @Override
    public IssueLocation primaryLocation() {
        return this.primaryLocation;
    }

    @Override
    public List<Issue.Flow> flows() {
        return this.flows.stream().map(l -> () -> Collections.unmodifiableList(new ArrayList(l))).collect(Collectors.toList());
    }

    @Override
    public void doSave() {
        Objects.requireNonNull(this.ruleKey, "ruleKey is mandatory on issue");
        Preconditions.checkState(this.primaryLocation != null, "Primary location is mandatory on every issue");
        this.storage.store(this);
    }
}

