/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.duplications.java;

import java.util.List;
import org.sonar.duplications.statement.matcher.TokenMatcher;
import org.sonar.duplications.token.Token;
import org.sonar.duplications.token.TokenQueue;

public class BridgeWithExceptionTokenMatcher
extends TokenMatcher {
    private final String lToken;
    private final String rToken;
    private final String except;

    public BridgeWithExceptionTokenMatcher(String lToken, String rToken, String except) {
        if (lToken == null || rToken == null || except == null) {
            throw new IllegalArgumentException();
        }
        this.lToken = lToken;
        this.rToken = rToken;
        this.except = except;
    }

    @Override
    public boolean matchToken(TokenQueue tokenQueue, List<Token> matchedTokenList) {
        if (!tokenQueue.isNextTokenValue(this.lToken)) {
            return false;
        }
        int stack = 0;
        while (tokenQueue.peek() != null) {
            Token token = tokenQueue.poll();
            matchedTokenList.add(token);
            if (this.lToken.equals(token.getValue())) {
                ++stack;
            } else if (this.rToken.equals(token.getValue())) {
                --stack;
            } else if (this.except.equals(token.getValue())) {
                return false;
            }
            if (stack != 0) continue;
            return true;
        }
        return false;
    }
}

