/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.fs.internal.charhandler;

import org.sonar.api.batch.fs.internal.charhandler.CharHandler;
import org.sonar.api.batch.fs.internal.charhandler.IntArrayList;

public class LineOffsetCounter
extends CharHandler {
    private long currentOriginalOffset = 0L;
    private IntArrayList originalLineOffsets = new IntArrayList();
    private long lastValidOffset = 0L;

    public LineOffsetCounter() {
        this.originalLineOffsets.add(0);
    }

    @Override
    public void handleAll(char c) {
        ++this.currentOriginalOffset;
    }

    @Override
    public void newLine() {
        if (this.currentOriginalOffset > Integer.MAX_VALUE) {
            throw new IllegalStateException("File is too big: " + this.currentOriginalOffset);
        }
        this.originalLineOffsets.add((int)this.currentOriginalOffset);
    }

    @Override
    public void eof() {
        this.lastValidOffset = this.currentOriginalOffset;
    }

    public int[] getOriginalLineOffsets() {
        return this.originalLineOffsets.trimAndGet();
    }

    public int getLastValidOffset() {
        if (this.lastValidOffset > Integer.MAX_VALUE) {
            throw new IllegalStateException("File is too big: " + this.lastValidOffset);
        }
        return (int)this.lastValidOffset;
    }
}

