/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.sensor.issue.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.sonar.api.batch.sensor.internal.DefaultStorable;
import org.sonar.api.batch.sensor.internal.SensorStorage;
import org.sonar.api.batch.sensor.issue.Issue;
import org.sonar.api.batch.sensor.issue.IssueLocation;
import org.sonar.api.batch.sensor.issue.NewIssueLocation;
import org.sonar.api.batch.sensor.issue.internal.DefaultIssueLocation;
import org.sonar.api.internal.google.common.base.Preconditions;

public abstract class AbstractDefaultIssue<T extends AbstractDefaultIssue>
extends DefaultStorable {
    protected IssueLocation primaryLocation;
    protected List<List<IssueLocation>> flows = new ArrayList<List<IssueLocation>>();

    protected AbstractDefaultIssue() {
        super(null);
    }

    public AbstractDefaultIssue(@Nullable SensorStorage storage) {
        super(storage);
    }

    public IssueLocation primaryLocation() {
        return this.primaryLocation;
    }

    public List<Issue.Flow> flows() {
        return this.flows.stream().map(l -> () -> Collections.unmodifiableList(new ArrayList(l))).collect(Collectors.toList());
    }

    public NewIssueLocation newLocation() {
        return new DefaultIssueLocation();
    }

    public T at(NewIssueLocation primaryLocation) {
        Preconditions.checkArgument(primaryLocation != null, "Cannot use a location that is null");
        Preconditions.checkState(this.primaryLocation == null, "at() already called");
        this.primaryLocation = (DefaultIssueLocation)primaryLocation;
        Preconditions.checkArgument(this.primaryLocation.inputComponent() != null, "Cannot use a location with no input component");
        return (T)this;
    }

    public T addLocation(NewIssueLocation secondaryLocation) {
        this.flows.add(Arrays.asList((IssueLocation)((Object)secondaryLocation)));
        return (T)this;
    }

    public T addFlow(Iterable<NewIssueLocation> locations) {
        ArrayList<DefaultIssueLocation> flowAsList = new ArrayList<DefaultIssueLocation>();
        for (NewIssueLocation issueLocation : locations) {
            flowAsList.add((DefaultIssueLocation)issueLocation);
        }
        this.flows.add(flowAsList);
        return (T)this;
    }
}

