/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.fs.internal.charhandler;

import java.nio.charset.Charset;
import org.sonar.api.batch.fs.internal.charhandler.CharHandler;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;

public class LineCounter
extends CharHandler {
    private static final Logger LOG = Loggers.get(LineCounter.class);
    private int lines = 1;
    private int nonBlankLines = 0;
    private boolean blankLine = true;
    boolean alreadyLoggedInvalidCharacter = false;
    private final String filePath;
    private final Charset encoding;

    public LineCounter(String filePath, Charset encoding) {
        this.filePath = filePath;
        this.encoding = encoding;
    }

    @Override
    public void handleAll(char c) {
        if (!this.alreadyLoggedInvalidCharacter && c == '\ufffd') {
            LOG.warn("Invalid character encountered in file {} at line {} for encoding {}. Please fix file content or configure the encoding to be used using property '{}'.", this.filePath, this.lines, this.encoding, "sonar.sourceEncoding");
            this.alreadyLoggedInvalidCharacter = true;
        }
    }

    @Override
    public void newLine() {
        ++this.lines;
        if (!this.blankLine) {
            ++this.nonBlankLines;
        }
        this.blankLine = true;
    }

    @Override
    public void handleIgnoreEoL(char c) {
        if (!Character.isWhitespace(c)) {
            this.blankLine = false;
        }
    }

    @Override
    public void eof() {
        if (!this.blankLine) {
            ++this.nonBlankLines;
        }
    }

    public int lines() {
        return this.lines;
    }

    public int nonBlankLines() {
        return this.nonBlankLines;
    }
}

