/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.rules;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import org.codehaus.staxmate.SMInputFactory;
import org.codehaus.staxmate.in.SMHierarchicCursor;
import org.codehaus.staxmate.in.SMInputCursor;
import org.sonar.api.PropertyType;
import org.sonar.api.ce.ComputeEngineSide;
import org.sonar.api.internal.apachecommons.io.FileUtils;
import org.sonar.api.internal.apachecommons.lang.StringUtils;
import org.sonar.api.internal.google.common.base.Strings;
import org.sonar.api.rules.Rule;
import org.sonar.api.rules.RuleParam;
import org.sonar.api.rules.RulePriority;
import org.sonar.api.server.ServerSide;
import org.sonar.api.utils.SonarException;
import org.sonar.check.Cardinality;

@Deprecated
@ServerSide
@ComputeEngineSide
public final class XMLRuleParser {
    private static final Map<String, String> TYPE_MAP = XMLRuleParser.typeMapWithDeprecatedValues();

    public List<Rule> parse(File file) {
        List<Rule> list;
        InputStreamReader reader = new InputStreamReader((InputStream)FileUtils.openInputStream(file), StandardCharsets.UTF_8);
        try {
            list = this.parse(reader);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)reader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new SonarException("Fail to load the file: " + file, e);
            }
        }
        ((Reader)reader).close();
        return list;
    }

    public List<Rule> parse(InputStream input) {
        List<Rule> list;
        InputStreamReader reader = new InputStreamReader(input, StandardCharsets.UTF_8);
        try {
            list = this.parse(reader);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)reader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new SonarException("Fail to load the xml stream", e);
            }
        }
        ((Reader)reader).close();
        return list;
    }

    public List<Rule> parse(Reader reader) {
        XMLInputFactory xmlFactory = XMLInputFactory.newInstance();
        xmlFactory.setProperty("javax.xml.stream.isCoalescing", Boolean.TRUE);
        xmlFactory.setProperty("javax.xml.stream.isNamespaceAware", Boolean.FALSE);
        xmlFactory.setProperty("javax.xml.stream.supportDTD", Boolean.FALSE);
        xmlFactory.setProperty("javax.xml.stream.isValidating", Boolean.FALSE);
        SMInputFactory inputFactory = new SMInputFactory(xmlFactory);
        try {
            SMHierarchicCursor rootC = inputFactory.rootElementCursor(reader);
            rootC.advance();
            ArrayList<Rule> rules = new ArrayList<Rule>();
            SMInputCursor rulesC = rootC.childElementCursor("rule");
            while (rulesC.getNext() != null) {
                Rule rule = Rule.create();
                rules.add(rule);
                XMLRuleParser.processRule(rule, rulesC);
            }
            return rules;
        }
        catch (XMLStreamException e) {
            throw new SonarException("XML is not valid", e);
        }
    }

    private static void processRule(Rule rule, SMInputCursor ruleC) throws XMLStreamException {
        String priorityAttribute;
        String keyAttribute = ruleC.getAttrValue("key");
        if (StringUtils.isNotBlank(keyAttribute)) {
            rule.setKey(StringUtils.trim(keyAttribute));
        }
        if (StringUtils.isNotBlank(priorityAttribute = ruleC.getAttrValue("priority"))) {
            rule.setSeverity(RulePriority.valueOf(StringUtils.trim(priorityAttribute)));
        }
        ArrayList<String> tags = new ArrayList<String>();
        SMInputCursor cursor = ruleC.childElementCursor();
        while (cursor.getNext() != null) {
            String nodeName = cursor.getLocalName();
            if (StringUtils.equalsIgnoreCase("name", nodeName)) {
                rule.setName(StringUtils.trim(cursor.collectDescendantText(false)));
                continue;
            }
            if (StringUtils.equalsIgnoreCase("description", nodeName)) {
                rule.setDescription(StringUtils.trim(cursor.collectDescendantText(false)));
                continue;
            }
            if (StringUtils.equalsIgnoreCase("key", nodeName)) {
                rule.setKey(StringUtils.trim(cursor.collectDescendantText(false)));
                continue;
            }
            if (StringUtils.equalsIgnoreCase("configKey", nodeName)) {
                rule.setConfigKey(StringUtils.trim(cursor.collectDescendantText(false)));
                continue;
            }
            if (StringUtils.equalsIgnoreCase("priority", nodeName)) {
                rule.setSeverity(RulePriority.valueOf(StringUtils.trim(cursor.collectDescendantText(false))));
                continue;
            }
            if (StringUtils.equalsIgnoreCase("cardinality", nodeName)) {
                rule.setCardinality(Cardinality.valueOf(StringUtils.trim(cursor.collectDescendantText(false))));
                continue;
            }
            if (StringUtils.equalsIgnoreCase("status", nodeName)) {
                rule.setStatus(StringUtils.trim(cursor.collectDescendantText(false)));
                continue;
            }
            if (StringUtils.equalsIgnoreCase("param", nodeName)) {
                XMLRuleParser.processParameter(rule, cursor);
                continue;
            }
            if (!StringUtils.equalsIgnoreCase("tag", nodeName)) continue;
            tags.add(StringUtils.trim(cursor.collectDescendantText(false)));
        }
        if (Strings.isNullOrEmpty(rule.getKey())) {
            throw new SonarException("Node <key> is missing in <rule>");
        }
        rule.setTags(tags.toArray(new String[tags.size()]));
    }

    private static void processParameter(Rule rule, SMInputCursor ruleC) throws XMLStreamException {
        String typeAttribute;
        RuleParam param = rule.createParameter();
        String keyAttribute = ruleC.getAttrValue("key");
        if (StringUtils.isNotBlank(keyAttribute)) {
            param.setKey(StringUtils.trim(keyAttribute));
        }
        if (StringUtils.isNotBlank(typeAttribute = ruleC.getAttrValue("type"))) {
            param.setType(XMLRuleParser.type(StringUtils.trim(typeAttribute)));
        }
        SMInputCursor paramC = ruleC.childElementCursor();
        while (paramC.getNext() != null) {
            String propNodeName = paramC.getLocalName();
            String propText = StringUtils.trim(paramC.collectDescendantText(false));
            if (StringUtils.equalsIgnoreCase("key", propNodeName)) {
                param.setKey(propText);
                continue;
            }
            if (StringUtils.equalsIgnoreCase("description", propNodeName)) {
                param.setDescription(propText);
                continue;
            }
            if (StringUtils.equalsIgnoreCase("type", propNodeName)) {
                param.setType(XMLRuleParser.type(propText));
                continue;
            }
            if (!StringUtils.equalsIgnoreCase("defaultValue", propNodeName)) continue;
            param.setDefaultValue(propText);
        }
        if (StringUtils.isEmpty(param.getKey())) {
            throw new SonarException("Node <key> is missing in <param>");
        }
    }

    private static Map<String, String> typeMapWithDeprecatedValues() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("i", PropertyType.INTEGER.name());
        map.put("s", PropertyType.STRING.name());
        map.put("b", PropertyType.BOOLEAN.name());
        map.put("r", PropertyType.REGULAR_EXPRESSION.name());
        map.put("s{}", "s{}");
        map.put("i{}", "i{}");
        for (PropertyType propertyType : PropertyType.values()) {
            map.put(propertyType.name(), propertyType.name());
        }
        return map;
    }

    static String type(String type) {
        String validType = TYPE_MAP.get(type);
        if (null != validType) {
            return validType;
        }
        if (type.matches(".\\[.+\\]")) {
            return type;
        }
        throw new SonarException("Invalid property type [" + type + "]");
    }
}

